

from OpenGL.GL import *
from oglpm import *
from whrandom import *
from Image import *
from att_obj import *


class Bboard(Att_Obj):
    def __init__(self,file,location = (0,0,0),quad = ((0,0,0),(1,0,0),(1,1,0),(0,1,0))):        
        self.image = open(file)
        Att_Obj.__init__(self,location)
        self.quad = quad
        self.ix = self.image.size[0]
        self.iy = self.image.size[1]
        self.image = self.image.tostring("raw", "RGBX", 0, -1)
	                 
    def texture(self):  
        glPixelStorei(GL_UNPACK_ALIGNMENT,1)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, self.ix, self.iy, 0, GL_RGBA, GL_UNSIGNED_BYTE,self.image)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
        glBegin(GL_QUADS)
        glTexCoord2f(0.0, 0.0);	glVertex3f(self.quad[0][0], self.quad[0][1], self.quad[0][2])
        glTexCoord2f(0.0, 1.0);	glVertex3f(self.quad[1][0], self.quad[1][1], self.quad[1][2])
        glTexCoord2f(1.0, 1.0);	glVertex3f(self.quad[2][0], self.quad[2][1], self.quad[2][2])
        glTexCoord2f(1.0, 0.0);	glVertex3f(self.quad[3][0], self.quad[3][1], self.quad[3][2])
        glEnd()

        
    def odraw(self):
        print 'drawing polkadots'
        glEnable(GL_TEXTURE_2D)
	glShadeModel(GL_FLAT)
        self.texture()
	glDisable(GL_TEXTURE_2D)
	glShadeModel(GL_SMOOTH)
        
	
class Quads_textured(Att_Obj):
    def __init__(self,file,location):
        Att_Obj.__init__(self,location)
        self.quads = []
        self.image = open(file)
        self.ix = self.image.size[0]
        self.iy = self.image.size[1]
        self.image = self.image.tostring("raw", "RGBX", 0, -1)
	
    def addquad(self,quad):
        self.quads.append(quad)

    def draw(self):  
        glEnable(GL_TEXTURE_2D)
        glShadeModel(GL_FLAT)
        glPixelStorei(GL_UNPACK_ALIGNMENT, 1)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, self.ix, self.iy, 0, GL_RGBA, GL_UNSIGNED_BYTE,self.image)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
        glBegin(GL_QUADS)
        for quad in self.quads:
            glTexCoord2f(0.0, 0.0)
            glVertex3f(quad[0][0],quad[0][1],quad[0][2])
            glTexCoord2f(1.0, 0.0)
            glVertex3f(quad[1][0],quad[1][1],quad[1][2])
            glTexCoord2f(1.0, 1.0)
            glVertex3f(quad[2][0],quad[2][1],quad[2][2])
            glTexCoord2f(0.0, 1.0)
            glVertex3f(quad[3][0],quad[3][1],quad[3][2])
        glEnd()
        glDisable(GL_TEXTURE_2D)
        glShadeModel(GL_SMOOTH)
	    	  
class Box(Quads_textured):
    def __init__(self,file,location = (0,0,0),dim = (100,100,100)):
        Quads_textured.__init__(self,file,location)
        x = dim[0]
        y = dim[1]
        z = dim[2]
        self.addquad(((-x,-y,-z),(x,-y,-z),(x,y,-z),(-x,y,-z)))
        self.addquad(((-x,-y,z),(x,-y,z),(x,y,z),(-x,y,z)))
        self.addquad(((-x,-y,-z),(-x,y,-z),(-x,y,z),(-x,-y,z)))
        self.addquad(((x,-y,-z),(x,y,-z),(x,y,z),(x,-y,z)))
        self.addquad(((-x,-y,-z),(x,-y,-z),(x,-y,z),(-x,-y,z)))
        self.addquad(((-x,y,-z),(x,y,-z),(x,y,z),(-x,y,z)))
        self.rotation_vector_x = 1   
        self.rotation_vector_y = 1   
        self.rotation_vector_z = 1   
        self.rotation_delta = 3
	
class Bezboard:

    def __init__(self,file):
        from Image import *	
        self.ctrlpoints = [ -1.5, -1.5, 4.0, -0.5, -1.5, 2.0, 0.5, -1.5,-1.0, 1.5, -1.5, 2.0, -1.5, -0.5, 1.0, -0.5, -0.5, 3.0, 0.5, -0.5,0.0, 1.5, -0.5, -1.0, -1.5, 0.5, 4.0, -0.5, 0.5, 0.0, 0.5, 0.5,3.0, 1.5, 0.5, 4.0, -1.5, 1.5, -2.0, -0.5, 1.5, -2.0, 0.5, 1.5,0.0, 1.5, 1.5, -1.0]
        self.texpts = [0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0]
        self.image = open(file)
        self.ix = self.image.size[0]
        self.iy = self.image.size[1]
        self.image = self.image.tostring("raw", "RGBX", 0, -1)
         
        
    def draw(self,distance):
        t =  1 - distance/100
        self.texpts = [0.0, 0.0, 0.0, t, t, 0.0, t, t]
        glDisable(GL_CULL_FACE)
        glMap2f(GL_MAP2_VERTEX_3, 0, 1, 3, 4, 2, 1, 12, 4, self.ctrlpoints)
        glMap2f(GL_MAP2_TEXTURE_COORD_2, 0, 1, 2, 2, 0, 1, 4, 2, self.texpts)
        glEnable(GL_MAP2_TEXTURE_COORD_2)
        glEnable(GL_MAP2_VERTEX_3)
        glMapGrid2f(20, 0.0, 1.0, 20, 0.0, 1.0)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        print type(self.image)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, self.ix, self.iy, 0,
		     GL_RGBA, GL_UNSIGNED_BYTE, self.image)
        glEnable(GL_TEXTURE_2D)
        glEnable(GL_DEPTH_TEST)
        glEnable(GL_NORMALIZE)
        glShadeModel(GL_FLAT)


        glEvalMesh2(GL_FILL, 0, 20, 0, 20)
        glEnable(GL_TEXTURE_2D)
        glShadeModel(GL_FLAT)

        glDisable(GL_TEXTURE_2D)
        glShadeModel(GL_SMOOTH)
        
class Tris_textured(Att_Obj):
    def __init__(self,file,location):
        Att_Obj.__init__(self,location)
        self.tris = []
        self.image = open(file)
        self.ix = self.image.size[0]
        self.iy = self.image.size[1]
        self.image = self.image.tostring("raw", "RGBX", 0, -1)
	
    def addtri(self,tri):
        self.tris.append(tri)

    def draw(self):  
        glEnable(GL_TEXTURE_2D)
        glShadeModel(GL_FLAT)
        glPixelStorei(GL_UNPACK_ALIGNMENT, 1)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, self.ix, self.iy, 0, GL_RGBA, GL_UNSIGNED_BYTE,self.image)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
        glBegin(GL_TRIANGLES)
        l = len(self.tris)
        for i in range(l):
            tri = self.tris[i]
            if i%2:
                a = 0.0
                b = 1.0
            else:
                a = 1.0
                b = 0.0
            glTexCoord2f(0.0, 0.0)
            glVertex3f(tri[0][0],tri[0][1],tri[0][2])
            glTexCoord2f(b, a)
            glVertex3f(tri[1][0],tri[1][1],tri[1][2])
            glTexCoord2f(1.0, 1.0)
            glVertex3f(tri[2][0],tri[2][1],tri[2][2])
        glEnd()
        glDisable(GL_TEXTURE_2D)
        glShadeModel(GL_SMOOTH)

class Texicosa(Tris_textured):
    def __init__(self,file,location = (0,0,0),scale = 1):
        Tris_textured.__init__(self,file,location)
        p0 = (0.0,0.0 ,2.0)
        p1 = (1.788854, 0.000000, 0.894427)
        p2 = (0.552786, 1.701302, 0.894427)
        p3 = (-1.447214, 1.051462, 0.894427)
        p4 = (-1.447214, -1.051462, 0.894427)
        p5 = (0.552786, -1.701302, 0.894427)
        p6 = (1.447214, 1.051462, -0.894427)
        p7 = (-0.552786, 1.701302, -0.894427)
        p8 = (-1.788854, 0.000000, -0.894427)
        p9 = (-0.552786, -1.701302, -0.894427)
        p10 = (1.447214, -1.051462, -0.894427)
        p11 = (0.0, 0.0, -2.0)

        self.addtri((p2, p0, p1))
        self.addtri((p3,  p0, p2))
        self.addtri((p4,  p0, p3))
        self.addtri((p5,  p0, p4)) 
        self.addtri((p1,  p0, p5))
        self.addtri((p2, p1, p6))
        self.addtri((p7, p2, p6))
        self.addtri((p3, p2, p7))
        self.addtri((p8, p3, p7 ))
        self.addtri((p4, p3, p8 ))
        self.addtri((p9, p4, p8)) 
        self.addtri((p5, p4, p9))
        self.addtri((p10, p5, p9))
        self.addtri((p6, p1, p10))
        self.addtri((p1, p5, p10))
        self.addtri((p6, p11, p7))
        self.addtri((p7, p11, p8))
        self.addtri((p8, p11, p9))
        self.addtri ((p9, p11, p10))
        self.addtri ((p10, p11, p6))
        self.rotation_vector_x = 1   
        self.rotation_vector_y = 1   
        self.rotation_vector_z = 1   
        self.rotation_delta = 3

        
        
    

        
