# Copyright (c) 2014,
# Mathias Kuhring, KuhringM@rki.de, Robert Koch Institute, Germany, 
# All rights reserved. For details, please note the license.txt.


# metric vote, by default TRUE when half of metrics/scores TRUE, but adjustable with min
voting <- function(scoreList, min=(length(scoreList)/2)){ 
  pro <- rep(0, length(scoreList[[1]]))
  contra <- rep(0, length(scoreList[[1]]))
  
  for (i in 1:length(scoreList)){
    pro <- pro + as.numeric(as.logical(scoreList[[i]]))
    contra <- contra + as.numeric(!as.logical(scoreList[[i]]))
  }
  
  choise <- (pro >= min)
  return(choise)
}


# returns the sum of TRUE votes
votingSum <- function(scoreList){ 
  pro <- rep(0, length(scoreList[[1]]))
  
  for (i in 1:length(scoreList)){
    pro <- pro + as.numeric(as.logical(scoreList[[i]]))
  }

  return(pro)
}


# returns the sum of weighted TRUE votes
weightedVotingSum <- function(scoreList, weightList){ 
  pro <- rep(0, length(scoreList[[1]]))
  
  for (i in 1:length(scoreList)){
    pro <- pro + as.numeric(as.logical(scoreList[[i]])) * weightList[[i]][,"TRUE"]
  }
  
  return(pro)
}