# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementNetworkSecurityPerimeterConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_configurations_get(self, resource_group):
        response = self.client.network_security_perimeter_configurations.get(
            resource_group_name=resource_group.name,
            resource_type="str",
            resource_name="str",
            perimeter_guid="str",
            association_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_configurations_begin_reconcile(self, resource_group):
        response = self.client.network_security_perimeter_configurations.begin_reconcile(
            resource_group_name=resource_group.name,
            resource_type="str",
            resource_name="str",
            perimeter_guid="str",
            association_name="str",
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_configurations_list(self, resource_group):
        response = self.client.network_security_perimeter_configurations.list(
            resource_group_name=resource_group.name,
            resource_type="str",
            resource_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
