package ONVIF::Device::Types::AudioDecoderConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Device::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
    },
    {
        'Name' => 'ONVIF::Device::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::AudioDecoderConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AudioDecoderConfiguration from the namespace http://www.onvif.org/ver10/schema.

The Audio Decoder Configuration does not contain any that parameter to configure the decoding .A decoder shall decode every data it receives (according to its capabilities).




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::AudioDecoderConfiguration
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

