/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.TextFieldSink;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class FileChooser {
    private final JFileChooser fc;
    private TextFieldSink fileName;
    private JLabel lname;

    public FileChooser(Box bdown, String name, final JembossParams mysettings) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            System.setSecurityManager(null);
        }
        this.fc = new JFileChooser();
        if (sm != null) {
            System.setSecurityManager(sm);
        }
        JButton openButton = new JButton("Browse files...");
        this.fileName = new TextFieldSink();
        Box pname = Box.createHorizontalBox();
        this.lname = new JLabel(name);
        this.lname.setFont(SectionPanel.labfont);
        bdown.add(pname);
        pname.add(this.lname);
        pname.add(Box.createHorizontalGlue());
        Box file = Box.createHorizontalBox();
        bdown.add(file);
        file.add(this.fileName);
        file.add(Box.createRigidArea(new Dimension(2, 2)));
        file.add(openButton);
        this.fc.addChoosableFileFilter(new SequenceFilter());
        openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                String dir = mysettings.getUserHome();
                File cwd = new File(dir);
                if (cwd.isDirectory() && cwd.canRead()) {
                    FileChooser.this.fc.setCurrentDirectory(cwd);
                }
                if ((returnVal = FileChooser.this.fc.showOpenDialog(FileChooser.this.fc)) == 0) {
                    String fileSelected = FileChooser.this.fc.getSelectedFile().getAbsolutePath();
                    FileChooser.this.fileName.setText(fileSelected);
                }
            }
        });
        file.add(Box.createHorizontalGlue());
    }

    public static Box simpleFileChooser(String name, final TextFieldSink fileName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            System.setSecurityManager(null);
        }
        final JFileChooser fc = new JFileChooser();
        if (sm != null) {
            System.setSecurityManager(sm);
        }
        fileName.setColumns(30);
        JButton openButton = new JButton("Browse files...");
        Box bdown = Box.createVerticalBox();
        Box pname = Box.createHorizontalBox();
        JLabel lname = new JLabel(name + ":");
        lname.setFont(SectionPanel.labfont);
        bdown.add(pname);
        pname.add(lname);
        pname.add(Box.createHorizontalGlue());
        Box file = Box.createHorizontalBox();
        bdown.add(file);
        file.add(Box.createRigidArea(new Dimension(2, 2)));
        file.add(fileName);
        file.add(Box.createRigidArea(new Dimension(2, 2)));
        file.add(openButton);
        openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(fc);
                if (returnVal == 0) {
                    String fileSelected = fc.getSelectedFile().getAbsolutePath();
                    fileName.setText(fileSelected);
                }
            }
        });
        file.add(Box.createHorizontalGlue());
        return bdown;
    }

    public String getFileChosen() {
        return this.fileName.getText();
    }

    public JFileChooser getJFileChooser() {
        return this.fc;
    }

    public TextFieldSink getTextFieldSink() {
        return this.fileName;
    }

    public void setText(String txt) {
        this.fileName.setText(txt);
    }

    public void setSize(Dimension d) {
        this.fileName.setPreferredSize(d);
        this.fileName.setMinimumSize(d);
        this.fileName.setMaximumSize(d);
    }

    public void setPreferredSize(Dimension d) {
        this.fileName.setPreferredSize(d);
    }

    public Dimension getPreferredSize() {
        return this.fileName.getPreferredSize();
    }

    public void setForeground(Color c) {
        this.lname.setForeground(c);
    }
}

