/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

 // Disable symbol overrides so that we can use system headers.
#define FORBIDDEN_SYMBOL_ALLOW_ALL

// HACK to allow building with the SDL backend on MinGW
// see bug #1800764 "TOOLS: MinGW tools building broken"
#ifdef main
#undef main
#endif // main

#include "file.h"
#include "script_quotes.h"

static const ScriptQuote BARBOT_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x0003D372 },
	{ 0x00000007, 0x00000000, 0x0003D72B },
	{ 0x00000004, 0x00000000, 0x0003D722 },
	{ 0x00000006, 0x00000000, 0x0003D264 },
	{ 0x00000005, 0x00000000, 0x0003D72F },
	{ 0x00000001, 0x00000032, 0x00000001 },
	{ 0x00000002, 0x00000032, 0x00000001 },
	{ 0x00000003, 0x00000032, 0x00000001 },
	{ 0x00000010, 0x54524156, 0x0003D2B1 },
	{ 0x00000010, 0x0000003C, 0x00000000 },
	{ 0x00000011, 0x00000000, 0x0003D484 },
	{ 0x00000015, 0x00000032, 0x0003D2B2 },
	{ 0x00000012, 0x00000042, 0x0003D499 },
	{ 0x00000013, 0x00000021, 0x0003D31E },
	{ 0x0000001D, 0x00000021, 0x0003D31E },
	{ 0x00000014, 0x00000042, 0x0003D49E },
	{ 0x00000016, 0x0000003C, 0x0003D2B6 },
	{ 0x00000017, 0x00000028, 0x0003D2B5 },
	{ 0x00000018, 0x00000000, 0x0003D35E },
	{ 0x00000019, 0x00000000, 0x0003D35E },
	{ 0x0000001A, 0x0000003C, 0x0003D38B },
	{ 0x0000001B, 0x00000000, 0x0003D2F8 },
	{ 0x00000009, 0x00000019, 0x0003D326 },
	{ 0x0000000A, 0x00000019, 0x0003D314 },
	{ 0x0000000B, 0x00000028, 0x0003D311 },
	{ 0x0000001E, 0x00000000, 0x0003D6F2 },
	{ 0x0000001F, 0x00000000, 0x0003D26C },
	{ 0x0000000C, 0x00000000, 0x0003D2F4 },
	{ 0x0000000D, 0x00000000, 0x0003D2F4 },
	{ 0x0000000E, 0x00000000, 0x0003D2F4 },
	{ 0x0000000F, 0x00000000, 0x0003D2F4 },
	{ 0x00000020, 0x00000019, 0x0003D389 },
	{ 0x00000021, 0x0000000F, 0x0003D29C },
	{ 0x00000022, 0x0000000F, 0x0003D494 },
	{ 0x0000001C, 0x00000032, 0x00000000 },
	{ 0x00000023, 0x00000000, 0x0003D7F8 },
	{ 0x00000024, 0x00000000, 0x0003D7F9 },
	{ 0x00000031, 0x00000000, 0x0003D722 },
	{ 0x00000032, 0x00000000, 0x0003D722 },
	{ 0x00000033, 0x00000000, 0x0003D372 },
	{ 0x00000034, 0x00000000, 0x0003D323 },
	{ 0x0000003E, 0x00000000, 0x0003D163 },
	{ 0x0000003F, 0x00000000, 0x0003D163 },
	{ 0x00000040, 0x00000000, 0x0003D163 },
	{ 0x00000041, 0x00000000, 0x0003D691 },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

static const ScriptQuote BELLBOT_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x00031116 },
	{ 0x00000007, 0x00000000, 0x00031447 },
	{ 0x00000006, 0x00000000, 0x000310F9 },
	{ 0x00000005, 0x00000000, 0x000313A1 },
	{ 0x00000001, 0x56424144, 0x000313D7 },
	{ 0x00000001, 0x52554445, 0x000313D7 },
	{ 0x00000001, 0x5052534E, 0x00041EB3 },
	{ 0x00000001, 0x424F5953, 0x00041EB3 },
	{ 0x00000001, 0x4749524C, 0x00041EB3 },
	{ 0x00000001, 0x464F4F44, 0x00041EB3 },
	{ 0x00000001, 0x00000032, 0x00041EB1 },
	{ 0x0000001C, 0x00000032, 0x00041EB0 },
	{ 0x00000010, 0x54524156, 0x000313C6 },
	{ 0x00000010, 0x0000003C, 0x00041EB0 },
	{ 0x00000011, 0x00000000, 0x0003139E },
	{ 0x00000015, 0x00000032, 0x0003139F },
	{ 0x00000012, 0x00000042, 0x000313A0 },
	{ 0x00000013, 0x00000021, 0x000313A7 },
	{ 0x0000001D, 0x00000021, 0x000313A7 },
	{ 0x00000014, 0x00000042, 0x000313A4 },
	{ 0x0000001B, 0x00000000, 0x0003139B },
	{ 0x0000001E, 0x00000000, 0x000313A2 },
	{ 0x0000001F, 0x00000000, 0x00030DC0 },
	{ 0x0000000C, 0x00000000, 0x000313A9 },
	{ 0x0000000D, 0x00000000, 0x000313A9 },
	{ 0x0000000E, 0x00000000, 0x000313A8 },
	{ 0x0000000F, 0x00000000, 0x000313A8 },
	{ 0x00000020, 0x00000019, 0x000313AB },
	{ 0x00000021, 0x0000000F, 0x000313AC },
	{ 0x00000023, 0x00000000, 0x00031337 },
	{ 0x00000024, 0x00000000, 0x0003135A },
	{ 0x00000025, 0x00000000, 0x000311AB },
	{ 0x00000026, 0x00000000, 0x0003112E },
	{ 0x00000030, 0x00000000, 0x0003106C },
	{ 0x00000027, 0x424F5953, 0x0003140C },
	{ 0x00000027, 0x4749524C, 0x0003140D },
	{ 0x00000027, 0x00000000, 0x0003140D },
	{ 0x00000028, 0x00000000, 0x00031404 },
	{ 0x00000029, 0x00000000, 0x00031405 },
	{ 0x0000002A, 0x00000000, 0x00031406 },
	{ 0x0000002B, 0x00000000, 0x00031407 },
	{ 0x0000002C, 0x00000000, 0x00031408 },
	{ 0x0000002D, 0x00000000, 0x00031409 },
	{ 0x0000002E, 0x424F5953, 0x0003140A },
	{ 0x0000002E, 0x4749524C, 0x0003140B },
	{ 0x0000002E, 0x00000000, 0x0003140B },
	{ 0x00000032, 0x00000000, 0x000313D6 },
	{ 0x00000033, 0x00000000, 0x000313D7 },
	{ 0x00000034, 0x00000000, 0x000313D8 },
	{ 0x00000035, 0x00000000, 0x0003113D },
	{ 0x00000036, 0x00000000, 0x00030DCB },
	{ 0x00000031, 0x00000000, 0x00030DB5 },
	{ 0x00000037, 0x00000000, 0x000313DD },
	{ 0x00000038, 0x00000000, 0x00030EE4 },
	{ 0x00000039, 0x00000000, 0x0003160B },
	{ 0x0000003A, 0x00000000, 0x000310C4 },
	{ 0x0000003B, 0x00000000, 0x000310C5 },
	{ 0x0000003C, 0x00000000, 0x0003121C },
	{ 0x0000003D, 0x00000000, 0x00031623 },
	{ 0x0000003F, 0x00000000, 0x00030D99 },
	{ 0x0000003E, 0x00000000, 0x00030D99 },
	{ 0x00000040, 0x00000000, 0x000315CE },
	{ 0x00000041, 0x00000000, 0x000315DC },
	{ 0x00000042, 0x00000000, 0x00031478 },
	{ 0x00000043, 0x00000000, 0x00030FC8 },
	{ 0x00000044, 0x00000000, 0x0003106D },
	{ 0x00000054, 0x00000000, 0x00031514 },
	{ 0x00000055, 0x00000000, 0x00031515 },
	{ 0x00000056, 0x00000000, 0x000315CF },
	{ 0x0000005A, 0x00000000, 0x000310F9 },
	{ 0x00000058, 0x00000000, 0x000315DF },
	{ 0x0000005B, 0x00000000, 0x00031620 },
	{ 0x0000005C, 0x00000000, 0x0003134B },
	{ 0x00000059, 0x00000000, 0x0003150F },
	{ 0x00000057, 0x00000000, 0x00030D58 },
	{ 0x00000045, 0x0000000A, 0x000310C3 },
	{ 0x00000046, 0x00000000, 0x00030EAD },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

static const ScriptQuote DESKBOT_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x0003ACD0 },
	{ 0x00000007, 0x00000000, 0x0003ACDC },
	{ 0x00000006, 0x00000000, 0x0003ABF9 },
	{ 0x00000005, 0x00000000, 0x0003AD04 },
	{ 0x00000001, 0x56424144, 0x0003AE27 },
	{ 0x00000001, 0x52554445, 0x0003AE27 },
	{ 0x00000001, 0x5052534E, 0x00041EB3 },
	{ 0x00000001, 0x464F4F44, 0x00041EB3 },
	{ 0x00000001, 0x00000032, 0x00041EB1 },
	{ 0x00000002, 0x56424144, 0x0003AE27 },
	{ 0x00000002, 0x52554445, 0x0003AE27 },
	{ 0x00000002, 0x5052534E, 0x00041EB3 },
	{ 0x00000002, 0x464F4F44, 0x00041EB3 },
	{ 0x00000002, 0x00000032, 0x00041EB1 },
	{ 0x00000003, 0x56424144, 0x0003AE0E },
	{ 0x00000003, 0x52554445, 0x0003AE0E },
	{ 0x00000003, 0x5052534E, 0x00041EB3 },
	{ 0x00000003, 0x464F4F44, 0x00041EB3 },
	{ 0x00000003, 0x00000032, 0x00041EB1 },
	{ 0x00000010, 0x54524156, 0x0003ACFE },
	{ 0x00000010, 0x0000003C, 0x00041EB0 },
	{ 0x00000011, 0x00000000, 0x0003ABF9 },
	{ 0x00000015, 0x00000032, 0x0003AC70 },
	{ 0x00000012, 0x00000042, 0x0003AC7E },
	{ 0x00000013, 0x00000021, 0x0003AC70 },
	{ 0x0000001D, 0x00000021, 0x0003AC09 },
	{ 0x00000014, 0x00000042, 0x0003AE07 },
	{ 0x0000001B, 0x00000000, 0x00041EB2 },
	{ 0x0000001E, 0x00000000, 0x0003ACC1 },
	{ 0x0000001F, 0x00000000, 0x0003AC3E },
	{ 0x0000000C, 0x00000000, 0x0003AE4C },
	{ 0x0000000D, 0x00000000, 0x0003AE4C },
	{ 0x0000000E, 0x00000000, 0x0003AE4B },
	{ 0x0000000F, 0x00000000, 0x0003AE4B },
	{ 0x00000020, 0x00000019, 0x0003AE24 },
	{ 0x00000021, 0x0000000F, 0x0003AE10 },
	{ 0x0000001C, 0x00000032, 0x00041EB0 },
	{ 0x00000023, 0x00000000, 0x0003AC46 },
	{ 0x00000024, 0x00000000, 0x0003AE1F },
	{ 0x00000025, 0x00000000, 0x0003AE14 },
	{ 0x00000026, 0x00000000, 0x0003AC7B },
	{ 0x00000030, 0x00000000, 0x0003AE3D },
	{ 0x00000027, 0x424F5953, 0x0003AE5D },
	{ 0x00000027, 0x4749524C, 0x0003AE5E },
	{ 0x00000027, 0x00000000, 0x0003AE5C },
	{ 0x00000028, 0x00000000, 0x0003AE5B },
	{ 0x00000029, 0x00000000, 0x0003AE58 },
	{ 0x0000002A, 0x00000000, 0x0003AE59 },
	{ 0x0000002B, 0x00000000, 0x0003AE5A },
	{ 0x0000002C, 0x00000000, 0x0003AE57 },
	{ 0x0000002D, 0x00000000, 0x0003AE5C },
	{ 0x0000002E, 0x424F5953, 0x0003AE5A },
	{ 0x0000002E, 0x4749524C, 0x0003AE5A },
	{ 0x0000002E, 0x00000000, 0x0003AE5A },
	{ 0x00000032, 0x00000000, 0x0003AE0E },
	{ 0x00000033, 0x00000000, 0x0003AE27 },
	{ 0x00000034, 0x00000000, 0x0003AE24 },
	{ 0x00000035, 0x00000000, 0x0003AE3E },
	{ 0x00000037, 0x00000000, 0x0003AE26 },
	{ 0x00000038, 0x00000000, 0x0003AEC0 },
	{ 0x00000039, 0x00000000, 0x0003AEC1 },
	{ 0x0000003A, 0x00000000, 0x0003AC7F },
	{ 0x0000003B, 0x00000000, 0x0003ADD5 },
	{ 0x0000003C, 0x00000000, 0x0003AEC5 },
	{ 0x0000003D, 0x00000000, 0x0003AEC9 },
	{ 0x0000003F, 0x00000000, 0x0003ABC5 },
	{ 0x0000003E, 0x00000000, 0x0003ABC5 },
	{ 0x00000040, 0x00000000, 0x0003AFB0 },
	{ 0x00000041, 0x00000000, 0x0003AFDC },
	{ 0x00000042, 0x00000000, 0x0003AFB5 },
	{ 0x00000043, 0x00000000, 0x0003AFDD },
	{ 0x00000044, 0x00000000, 0x0003AFDD },
	{ 0x00000045, 0x0000000A, 0x0003AC7E },
	{ 0x00000046, 0x00000000, 0x0003AF6E },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

static const ScriptQuote DOORBOT_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x00035F14 },
	{ 0x00000007, 0x00000000, 0x00035F6F },
	{ 0x00000004, 0x00000000, 0x000360BF },
	{ 0x00000006, 0x00000000, 0x000360AF },
	{ 0x00000005, 0x00000000, 0x000360BC },
	{ 0x00000001, 0x56424144, 0x000360C0 },
	{ 0x00000001, 0x52554445, 0x000360C0 },
	{ 0x00000001, 0x5052534E, 0x00000003 },
	{ 0x00000001, 0x464F4F44, 0x00000003 },
	{ 0x00000001, 0x00000032, 0x00000001 },
	{ 0x00000002, 0x56424144, 0x000360C0 },
	{ 0x00000002, 0x52554445, 0x000360C0 },
	{ 0x00000002, 0x5052534E, 0x00000003 },
	{ 0x00000002, 0x464F4F44, 0x00000003 },
	{ 0x00000002, 0x00000032, 0x00000001 },
	{ 0x00000003, 0x56424144, 0x000360C0 },
	{ 0x00000003, 0x52554445, 0x000360C0 },
	{ 0x00000003, 0x5052534E, 0x00000003 },
	{ 0x00000003, 0x464F4F44, 0x00000003 },
	{ 0x00000003, 0x00000032, 0x00000001 },
	{ 0x00000010, 0x54524156, 0x00035F6A },
	{ 0x00000010, 0x0000003C, 0x00000000 },
	{ 0x00000011, 0x00000000, 0x0003604F },
	{ 0x00000015, 0x00000032, 0x00036046 },
	{ 0x00000012, 0x00000042, 0x00036057 },
	{ 0x00000013, 0x00000021, 0x00035FC8 },
	{ 0x0000001D, 0x00000021, 0x00035FC8 },
	{ 0x00000014, 0x00000042, 0x00036059 },
	{ 0x00000016, 0x0000003C, 0x00035F6E },
	{ 0x00000017, 0x00000028, 0x00035F6D },
	{ 0x00000018, 0x00000000, 0x00035F68 },
	{ 0x00000019, 0x00000000, 0x00035F68 },
	{ 0x0000001A, 0x0000003C, 0x00035F67 },
	{ 0x0000001B, 0x00000000, 0x00035FA0 },
	{ 0x00000009, 0x00000019, 0x00035FD3 },
	{ 0x0000000A, 0x00000019, 0x00036051 },
	{ 0x0000000B, 0x00000028, 0x00035FC4 },
	{ 0x0000001E, 0x00000000, 0x00035F5C },
	{ 0x0000001F, 0x00000000, 0x00035F5C },
	{ 0x0000000C, 0x00000000, 0x00035F9D },
	{ 0x0000000D, 0x00000000, 0x00035F9D },
	{ 0x0000000E, 0x00000000, 0x00035F9C },
	{ 0x0000000F, 0x00000000, 0x00035F9C },
	{ 0x00000020, 0x00000019, 0x00035FFF },
	{ 0x00000021, 0x0000000F, 0x00035F59 },
	{ 0x00000022, 0x0000000F, 0x00036055 },
	{ 0x0000001C, 0x00000032, 0x00000000 },
	{ 0x00000023, 0x00000000, 0x000360C3 },
	{ 0x00000024, 0x00000000, 0x00035F5B },
	{ 0x00000025, 0x00000000, 0x00035EFE },
	{ 0x00000026, 0x00000000, 0x00035F03 },
	{ 0x0000002C, 0x00000000, 0x000360C0 },
	{ 0x0000002D, 0x00000000, 0x000360C0 },
	{ 0x00000030, 0x00000000, 0x00035F42 },
	{ 0x00000031, 0x00000000, 0x000360BF },
	{ 0x00000032, 0x00000000, 0x000360BF },
	{ 0x00000033, 0x00000000, 0x000360C0 },
	{ 0x00000034, 0x00000000, 0x00035FC9 },
	{ 0x00000035, 0x00000000, 0x00035E8B },
	{ 0x00000036, 0x00000000, 0x00035DFA },
	{ 0x00000037, 0x00000000, 0x000363AB },
	{ 0x00000038, 0x00000000, 0x00035F0F },
	{ 0x0000003C, 0x00000000, 0x00036379 },
	{ 0x0000003E, 0x00000000, 0x00036262 },
	{ 0x0000003F, 0x00000000, 0x00036262 },
	{ 0x00000040, 0x00000000, 0x00036271 },
	{ 0x00000041, 0x00000000, 0x0003626C },
	{ 0x00000042, 0x00000000, 0x0003625D },
	{ 0x00000043, 0x00000000, 0x0003649B },
	{ 0x00000044, 0x00000000, 0x0003649B },
	{ 0x00000046, 0x00000000, 0x00036035 },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

static const ScriptQuote LIFTBOT_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x00033655 },
	{ 0x00000007, 0x00000000, 0x000335A0 },
	{ 0x00000006, 0x00000000, 0x0003368B },
	{ 0x00000005, 0x00000028, 0x00033693 },
	{ 0x00000001, 0x56424144, 0x00033695 },
	{ 0x00000001, 0x52554445, 0x00033695 },
	{ 0x00000001, 0x5052534E, 0x00000003 },
	{ 0x00000001, 0x464F4F44, 0x00000003 },
	{ 0x00000001, 0x00000032, 0x00000001 },
	{ 0x00000002, 0x56424144, 0x00033695 },
	{ 0x00000002, 0x52554445, 0x00033695 },
	{ 0x00000002, 0x5052534E, 0x00000003 },
	{ 0x00000002, 0x464F4F44, 0x00000003 },
	{ 0x00000002, 0x00000032, 0x00000001 },
	{ 0x00000003, 0x56424144, 0x00033695 },
	{ 0x00000003, 0x52554445, 0x00033695 },
	{ 0x00000003, 0x5052534E, 0x00000003 },
	{ 0x00000003, 0x464F4F44, 0x00000003 },
	{ 0x00000003, 0x00000032, 0x00000001 },
	{ 0x00000010, 0x54524156, 0x000335A4 },
	{ 0x00000010, 0x0000003C, 0x00000000 },
	{ 0x00000011, 0x00000000, 0x0003367B },
	{ 0x00000015, 0x00000032, 0x000335A1 },
	{ 0x00000012, 0x00000042, 0x00033672 },
	{ 0x00000013, 0x00000021, 0x00033679 },
	{ 0x0000001D, 0x00000021, 0x00033679 },
	{ 0x00000014, 0x00000042, 0x00033688 },
	{ 0x00000016, 0x0000003C, 0x000335A4 },
	{ 0x00000017, 0x00000028, 0x00033689 },
	{ 0x00000018, 0x00000000, 0x00033670 },
	{ 0x00000019, 0x00000000, 0x000335A0 },
	{ 0x0000001A, 0x0000003C, 0x0003368F },
	{ 0x0000001B, 0x00000000, 0x00033695 },
	{ 0x00000009, 0x00000019, 0x000335A2 },
	{ 0x0000000A, 0x00000019, 0x000335A6 },
	{ 0x0000000B, 0x00000028, 0x00033668 },
	{ 0x0000001E, 0x00000000, 0x00033691 },
	{ 0x0000001F, 0x00000000, 0x00033691 },
	{ 0x0000000C, 0x00000014, 0x00033666 },
	{ 0x0000000D, 0x00000014, 0x00033666 },
	{ 0x0000000E, 0x00000014, 0x0003367A },
	{ 0x0000000F, 0x00000014, 0x0003367A },
	{ 0x00000020, 0x00000019, 0x0003367C },
	{ 0x00000021, 0x0000000F, 0x00033690 },
	{ 0x00000022, 0x0000000F, 0x00033682 },
	{ 0x0000001C, 0x00000032, 0x00000000 },
	{ 0x00000023, 0x00000000, 0x00033698 },
	{ 0x00000024, 0x00000000, 0x00033699 },
	{ 0x00000031, 0x00000000, 0x00033694 },
	{ 0x00000032, 0x00000000, 0x00033694 },
	{ 0x00000033, 0x00000000, 0x00033695 },
	{ 0x00000034, 0x00000000, 0x0003369F },
	{ 0x00000035, 0x00000000, 0x000336A0 },
	{ 0x00000036, 0x00000000, 0x00033585 },
	{ 0x0000003E, 0x00000000, 0x0003380D },
	{ 0x0000003F, 0x00000000, 0x0003380D },
	{ 0x00000040, 0x00000000, 0x0003380D },
	{ 0x00000041, 0x00000000, 0x000337E7 },
	{ 0x00000042, 0x00000000, 0x00033711 },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

static const ScriptQuote MAITRED_QUOTES[] = {
	{ 0x00000008, 0x00000000, 0x0003F967 },
	{ 0x00000007, 0x00000000, 0x0003F995 },
	{ 0x00000006, 0x00000000, 0x0003F833 },
	{ 0x00000005, 0x00000000, 0x0003F95B },
	{ 0x00000001, 0x56424144, 0x0003F847 },
	{ 0x00000001, 0x52554445, 0x0003F847 },
	{ 0x00000001, 0x5052534E, 0x00041EB3 },
	{ 0x00000001, 0x464F4F44, 0x0003FB88 },
	{ 0x00000001, 0x00000032, 0x00041EB1 },
	{ 0x00000010, 0x54524156, 0x0003F9FA },
	{ 0x00000010, 0x0000003C, 0x00041EB0 },
	{ 0x00000011, 0x00000000, 0x0003F967 },
	{ 0x00000015, 0x00000032, 0x0003F83D },
	{ 0x00000012, 0x00000042, 0x0003F83D },
	{ 0x00000013, 0x00000021, 0x0003F95B },
	{ 0x0000001D, 0x00000021, 0x0003F971 },
	{ 0x00000014, 0x00000042, 0x0003F96C },
	{ 0x0000001B, 0x00000000, 0x0003F95B },
	{ 0x0000001E, 0x00000000, 0x0003FA3C },
	{ 0x0000001F, 0x00000000, 0x0003F991 },
	{ 0x0000000C, 0x00000000, 0x0003F9C9 },
	{ 0x0000000D, 0x00000000, 0x0003F9C9 },
	{ 0x0000000E, 0x00000000, 0x0003F9C9 },
	{ 0x0000000F, 0x00000000, 0x0003F9C9 },
	{ 0x00000020, 0x00000019, 0x0003F847 },
	{ 0x00000021, 0x0000000F, 0x0003FA22 },
	{ 0x00000037, 0x00000000, 0x0003FA9C },
	{ 0x0000003C, 0x00000000, 0x0003FAA0 },
	{ 0x00000047, 0x00000000, 0x0003FAA1 },
	{ 0x0000003F, 0x00000000, 0x0003FABD },
	{ 0x0000003E, 0x00000000, 0x0003FABD },
	{ 0x00000040, 0x00000000, 0x0003FABB },
	{ 0x00000041, 0x00000000, 0x0003FABB },
	{ 0x00000042, 0x00000000, 0x0003FABC },
	{ 0x00000048, 0x00000000, 0x0003FB45 },
	{ 0x00000049, 0x00000000, 0x0003FB48 },
	{ 0x0000004A, 0x00000000, 0x0003FB52 },
	{ 0x0000004B, 0x00000000, 0x0003FB4A },
	{ 0x0000004C, 0x00000000, 0x0003FB47 },
	{ 0x0000004D, 0x00000000, 0x0003FB49 },
	{ 0x0000004E, 0x00000000, 0x0003FB53 },
	{ 0x0000004F, 0x00000000, 0x0003FB4C },
	{ 0x00000050, 0x00000000, 0x0003FB4E },
	{ 0x00000051, 0x00000000, 0x0003FB50 },
	{ 0x00000052, 0x00000000, 0x0003FB75 },
	{ 0x00000053, 0x00000000, 0x0003F9A8 },
	{ 0x00000000, 0x00000000, 0x00000000 }
};

void writeScriptQuotes(const char *name, const ScriptQuote *quotes,
		uint tag1, uint tag2, uint rangeStart, uint rangeEnd) {
	outputFile.seek(dataOffset);
	outputFile.writeLong(tag1);
	outputFile.writeLong(tag2);
	outputFile.writeLong(rangeStart);
	outputFile.writeLong(rangeEnd);

	for (; quotes->_index; ++quotes) {
		outputFile.writeLong(quotes->_index);
		outputFile.writeLong(quotes->_tagId);
		outputFile.writeLong(quotes->_dialogueId);
	}

	uint size = outputFile.size() - dataOffset;
	writeEntryHeader(name, dataOffset, size);
	dataOffset += size;
}

void writeAllScriptQuotes() {
	writeScriptQuotes("Quotes/Barbot", BARBOT_QUOTES, 221376, 221375, 0, 999);
	writeScriptQuotes("Quotes/Bellbot", BELLBOT_QUOTES, 201687, 201686, 270000, 270500);
	writeScriptQuotes("Quotes/Deskbot", DESKBOT_QUOTES, 241191, 241166, 270000, 270500);
	writeScriptQuotes("Quotes/Doorbot", DOORBOT_QUOTES, 221376, 221375, 0, 999);
	writeScriptQuotes("Quotes/Liftbot", LIFTBOT_QUOTES, 210581, 210580, 0, 999);
	writeScriptQuotes("Quotes/MaitreD", MAITRED_QUOTES, 260167, 260147, 270000, 270500);
}
