#ifndef LISTFILE_H
#define LISTFILE_H

#include <QObject>
#include <QWidget>

class ListFileHandler : public QObject
{
  Q_OBJECT
public:
  QStringList REL_RESTR_CARDS;
  explicit ListFileHandler(QString lstpath, QString lstname, QObject *parent = 0);
  bool success;   //! turns to true if refinement was a sucess.
  bool getSuccess() const;
  void setSuccess(bool value);
  QStringList loadLst();
  QString restraintsTable();
private:
  QVector<QStringList> listfileparser();
  QStringList lineformatter(QStringList line);
  QString table_maker(QVector<QStringList> tabledata);
  QString row(QStringList rowdata);
  QStringList *listfcontent;
  QString full_lstpath;
  QString *my_lstname;
  QString thetaFromLst();
signals:
  void listfile_changed(QString line);
  void lstFinished();
public slots:
};

struct LstData {
  //! Data structure for SHELXL output information
  QString xlversion;            //! SHELXL version number
  QString cmdline;              //! SHELXL command line option
  QString threads;              //! number of threads used
  QString procs;                //! number of processors used
  QString rint;                 //! R(int)
  QString rsigma;               //! R(sigma)
  QString wr2;                  //! current wr2
  QString cycle;                //! current cycle
  QString data;                 //! number of data
  QString current_parameters;   //! current number of refinement parameters
  QString all_parameters;       //! number of all possible refinement parameters
  QString curGoof;              //! current Goof for current cycle
  QString curRGoof;             //! current restraint Goof for current cycle
  QString finalwR2;             //! wR2 after refinement (all data)
  QString R1_4sig;              //! R1 after refinement with I > 4sig(I)
  QString R1_all;               //! R1 (all data) after refinement
  QString finalGoof;            //! Goof after refinement
  QString finalrestrGoof;       //! restraint Goof after refinement
  QString meanshift;            //! Mean shift per esd in current cycle
  QString maxshift_esd;         //! Maximum shift per estimated standard deviation in current cycle
  QString max_shift_esd_for;    //! Atom with the maximum shift per esd
  QString maxshift;             //! Maximum shift in Angstrom in current cycle
  QString maxshiftfor;          //! Atom with the maximum shift
  QString dU;                   //! Maximum delta U in current cycle
  QString dUfor;                //! Atom with maximum delta U in current cycle
  QString peak;                 //! Largest elektron density peak after refinement
  QString hole;                 //! Deepest hole after refinement
  QString peakpos;              //! Peak position
  QString holepos;              //! Hole position
  QString peakdist;             //! Distance of peak to next atom
  QString peakfrom;             //! Nearest atom from peak position
  QString holedist;             //! Distance of hole to next atom
  QString holefrom;             //! Nearest atom hole position
  QString warning;              //! A SHELXL warn message
  QStringList warnings;         //! All SHELXL warn messages
  QString flack;                //! Final flack x parametr
  QString parson;               //! Final Parson z parameter
};


typedef struct {
  //! Data structure for residuals to plot
  int     cycle;
  qreal   wR2;
  qreal   final_wR2;
  qreal   Goof;
  qreal   meanshift;
  qreal   maxshift_esd;
  QString max_shift_esd_for;
  qreal   maxshift;
  QString maxshiftfor;
  qreal   dU;
  QString dUfor;
  QString warning;
  QStringList warnings;
} RGraph;


class XLOutputParser : public QObject
{
  Q_OBJECT

public:
  explicit XLOutputParser(QObject *parent = 0);
private:
  LstData listf_data;
  RGraph rgr;
  void fillListFileData(QString line);
  QStringList warnings;
signals:
  LstData newLScycle();

public slots:
  QStringList xl_threads(QString line);
  QString xl_version(QString line);
  QString xl_cmdline(QString line);
  QStringList xl_current_wr2_data_param(QString line);
  QStringList xl_rint_rsigma(QString line);
  int xl_syst_abs_bad_equiv(QString line);
  QStringList xl_current_goof(QString line);
  QStringList xl_final_goofs(QString line);
  QStringList xl_current_max_shift(QString line);
  QStringList xl_current_meanshift_esd(QString line);
  QString xl_current_warning(QString line);
  void xl_collect_warnings(QString line);
  QString xl_final_R1_4sig(QString line);
  QString xl_final_wR2(QString line);
  QString residualsTextDisplay(QString line);
  QStringList xl_hole(QString line);
  QStringList xl_peak(QString line);
  RGraph residualsGraphDisplay();
  QStringList xl_flacksvals(QString line);
  QString xl_final_R1all(QString line);
};


class ListFileWidget : public QWidget
{
  Q_OBJECT

public:
  explicit ListFileWidget(QObject *parent = 0);

private:

signals:

public slots:

};

#endif // LISTFILE_H
