/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PAIR_H
#define _SC_PAIR_H


template<typename T> struct Pair
{
public:
  Pair( const T& p1, const T& p2 )
  : one(p1), two(p2)
  {
  }

  bool equal() const
  {
    return one == two;
  }

  T one;
  T two;
};

typedef Pair<int> IntPair;


#endif // _SC_PAIR_H

