/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CommitInfo.h"

// svn
#include <svn_client.h>


namespace svn
{

CommitInfo::CommitInfo() : _revnum(InvalidRevnumber), _date(0), _author(0)
{
}

void CommitInfo::operator=( svn_client_commit_info_t* info )
{
  if( ! info )
  {
    return;
  }

  _revnum = info->revision;
  _author = sc::String(info->author);
  _date   = sc::String(info->date);
}

Revnumber CommitInfo::getRevnumber() const
{
  return _revnum;
}

const sc::String& CommitInfo::getDate() const
{
  return _date;
}

const sc::String& CommitInfo::getAuthor() const
{
  return _author;
}



} // namespace

