
import glitch
import glitch.glut
import glitch.limbo.lights
import glitch.limbo.objects
import glitch.limbo.unitview

class Shader(glitch.Shader):
    vertex = """
        varying vec4 vertex;

        void main()
        {
            gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
            gl_TexCoord[0] = gl_MultiTexCoord0;
            vertex = gl_Vertex;
        }
        """

    fragment = """
        varying vec4 vertex;
        uniform sampler2D texture;

        void main()
        {
            gl_FragColor = vertex * texture2D(texture, gl_TexCoord[0].st);
        }
        """

if __name__ == '__main__':
    camera = glitch.glut.GLUTCamera(children=[
        glitch.limbo.unitview.UnitView(children=[
        glitch.ApplyTexture(
            glitch.CameraTexture(800, 600, eye=[0, 1, 3], children=[
                glitch.limbo.objects.make_lit_test_scene()]),
            children=[Shader(children=[
                glitch.TexturedSquare()])])])])
    camera.run()

