/* ibus-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "IBus", gir_namespace = "IBus", gir_version = "1.0", lower_case_cprefix = "ibus_")]
namespace IBus {
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_attr_list_get_type ()")]
	public class AttrList : IBus.Serializable {
		public weak GLib.Array<void*> attributes;
		[CCode (has_construct_function = false)]
		public AttrList ();
		public void append (IBus.Attribute attr);
		public unowned IBus.Attribute @get (uint index);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_attribute_get_type ()")]
	public class Attribute : IBus.Serializable {
		public uint end_index;
		public uint start_index;
		public uint type;
		public uint value;
		[CCode (has_construct_function = false)]
		public Attribute (uint type, uint value, uint start_index, uint end_index);
		public uint get_attr_type ();
		public uint get_end_index ();
		public uint get_start_index ();
		public uint get_value ();
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_bus_get_type ()")]
	public class Bus : IBus.Object {
		[CCode (has_construct_function = false)]
		public Bus ();
		public bool add_match (string rule);
		public async void add_match_async (string rule, int timeout_msec, GLib.Cancellable? cancellable);
		public bool add_match_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public async void create_input_context_async (string client_name, int timeout_msec, GLib.Cancellable? cancellable);
		public string current_input_context ();
		public async void current_input_context_async (int timeout_msec, GLib.Cancellable? cancellable);
		public string current_input_context_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool exit (bool restart);
		public async void exit_async (bool restart, int timeout_msec, GLib.Cancellable? cancellable);
		public bool exit_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned IBus.Config get_config ();
		public unowned GLib.DBusConnection get_connection ();
		public unowned IBus.EngineDesc get_global_engine ();
		public async void get_global_engine_async (int timeout_msec, GLib.Cancellable? cancellable);
		public unowned IBus.EngineDesc get_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public string get_name_owner (string name);
		public async void get_name_owner_async (string name, int timeout_msec, GLib.Cancellable? cancellable);
		public string get_name_owner_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool get_use_global_engine ();
		public async void get_use_global_engine_async (int timeout_msec, GLib.Cancellable? cancellable);
		public bool get_use_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool get_use_sys_layout ();
		public async void get_use_sys_layout_async (int timeout_msec, GLib.Cancellable? cancellable);
		public bool get_use_sys_layout_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned string hello ();
		public bool is_connected ();
		public bool is_global_engine_enabled ();
		public async void is_global_engine_enabled_async (int timeout_msec, GLib.Cancellable? cancellable);
		public bool is_global_engine_enabled_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<weak IBus.EngineDesc> list_active_engines ();
		public async void list_active_engines_async (int timeout_msec, GLib.Cancellable? cancellable);
		public GLib.List<weak IBus.EngineDesc> list_active_engines_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<weak IBus.EngineDesc> list_engines ();
		public async void list_engines_async (int timeout_msec, GLib.Cancellable? cancellable);
		public GLib.List<weak IBus.EngineDesc> list_engines_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<string> list_names ();
		public GLib.List<string> list_queued_owners (string name);
		public bool name_has_owner (string name);
		public async void name_has_owner_async (string name, int timeout_msec, GLib.Cancellable? cancellable);
		public bool name_has_owner_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool register_component (IBus.Component component);
		public async void register_component_async (IBus.Component component, int timeout_msec, GLib.Cancellable? cancellable);
		public bool register_component_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public uint release_name (string name);
		public async void release_name_async (string name, int timeout_msec, GLib.Cancellable? cancellable);
		public uint release_name_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool remove_match (string rule);
		public async void remove_match_async (string rule, int timeout_msec, GLib.Cancellable? cancellable);
		public bool remove_match_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public uint32 request_name (string name, uint32 flags);
		public async void request_name_async (string name, uint flags, int timeout_msec, GLib.Cancellable? cancellable);
		public uint request_name_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool set_global_engine (string global_engine);
		public async void set_global_engine_async (string global_engine, int timeout_msec, GLib.Cancellable? cancellable);
		public bool set_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public void set_watch_dbus_signal (bool watch);
		public void set_watch_ibus_signal (bool watch);
		public signal void connected ();
		public signal void disconnected ();
		public signal void global_engine_changed (string name);
		public signal void name_owner_changed (string name, string old_owner, string new_owner);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_component_get_type ()")]
	public class Component : IBus.Serializable {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak void*[] pdummy;
		[CCode (has_construct_function = false)]
		public Component (string name, string description, string version, string license, string author, string homepage, string command_line, string textdomain);
		public void add_engine (IBus.EngineDesc engine);
		public void add_observed_path (string path, bool access_fs);
		public bool check_modification ();
		[CCode (has_construct_function = false)]
		public Component.from_file (string filename);
		public unowned string get_author ();
		public unowned string get_description ();
		public GLib.List<weak IBus.EngineDesc> get_engines ();
		public unowned string get_exec ();
		public unowned string get_homepage ();
		public unowned string get_license ();
		public unowned string get_name ();
		public unowned string get_textdomain ();
		public unowned string get_version ();
		public void output (GLib.StringBuilder output, int indent);
		public void output_engines (GLib.StringBuilder output, int indent);
		public string author { get; construct; }
		[NoAccessorMethod]
		public string command_line { owned get; construct; }
		public string description { get; construct; }
		public string homepage { get; construct; }
		public string license { get; construct; }
		public string name { get; construct; }
		public string textdomain { get; construct; }
		public string version { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_config_get_type ()")]
	public class Config : IBus.Proxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		[CCode (has_construct_function = false)]
		public Config (GLib.DBusConnection connection, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Config.async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.Variant get_value (string section, string name);
		public async void get_value_async (string section, string name, int timeout_ms, GLib.Cancellable? cancellable);
		public GLib.Variant get_value_async_finish (GLib.AsyncResult result) throws GLib.Error;
		public GLib.Variant get_values (string section);
		public async void get_values_async (string section, int timeout_ms, GLib.Cancellable? cancellable);
		public GLib.Variant get_values_async_finish (GLib.AsyncResult result) throws GLib.Error;
		public static async void new_async (GLib.DBusConnection connection, GLib.Cancellable? cancellable);
		public bool set_value (string section, string name, GLib.Variant value);
		public async void set_value_async (string section, string name, GLib.Variant value, int timeout_ms, GLib.Cancellable? cancellable);
		public bool set_value_async_finish (GLib.AsyncResult result) throws GLib.Error;
		public bool unset (string section, string name);
		public signal void value_changed (string section, string name, GLib.Variant value);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_config_service_get_type ()")]
	public class ConfigService : IBus.Service {
		[CCode (has_construct_function = false)]
		public ConfigService (GLib.DBusConnection connection);
		[NoWrapper]
		public virtual GLib.Variant get_value (string section, string name) throws GLib.Error;
		[NoWrapper]
		public virtual GLib.Variant get_values (string section) throws GLib.Error;
		[NoWrapper]
		public virtual bool set_value (string section, string name, GLib.Variant value) throws GLib.Error;
		[NoWrapper]
		public virtual bool unset_value (string section, string name) throws GLib.Error;
		public void value_changed (string section, string name, GLib.Variant value);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_engine_get_type ()")]
	public class Engine : IBus.Service {
		public uint client_capabilities;
		public IBus.Rectangle cursor_area;
		public bool enabled;
		public bool has_focus;
		[CCode (has_construct_function = false)]
		public Engine (string engine_name, string object_path, GLib.DBusConnection connection);
		public void commit_text (IBus.Text text);
		public void delete_surrounding_text (int offset, uint nchars);
		public void forward_key_event (uint keyval, uint keycode, uint state);
		public unowned string get_name ();
		public void get_surrounding_text (out unowned IBus.Text text, out uint cursor_pos, out uint anchor_pos);
		public void hide_auxiliary_text ();
		public void hide_lookup_table ();
		public void hide_preedit_text ();
		public void register_properties (IBus.PropList prop_list);
		public void show_auxiliary_text ();
		public void show_lookup_table ();
		public void show_preedit_text ();
		public void update_auxiliary_text (IBus.Text text, bool visible);
		public void update_lookup_table (IBus.LookupTable lookup_table, bool visible);
		public void update_lookup_table_fast (IBus.LookupTable lookup_table, bool visible);
		public void update_preedit_text (IBus.Text text, uint cursor_pos, bool visible);
		public void update_preedit_text_with_mode (IBus.Text text, uint cursor_pos, bool visible, IBus.PreeditFocusMode mode);
		public void update_property (IBus.Property prop);
		[CCode (has_construct_function = false)]
		public Engine.with_type (GLib.Type engine_type, string engine_name, string object_path, GLib.DBusConnection connection);
		[NoAccessorMethod]
		public string engine_name { owned get; construct; }
		public virtual signal void cancel_hand_writing (uint n_strokes);
		public virtual signal void candidate_clicked (uint index, uint button, uint state);
		public virtual signal void cursor_down ();
		public virtual signal void cursor_up ();
		public virtual signal void disable ();
		public virtual signal void enable ();
		public virtual signal void focus_in ();
		public virtual signal void focus_out ();
		public virtual signal void page_down ();
		public virtual signal void page_up ();
		public virtual signal void process_hand_writing_event (void* coordinates, uint coordinates_len);
		public virtual signal bool process_key_event (uint keyval, uint keycode, uint state);
		public virtual signal void property_activate (string prop_name, uint prop_state);
		public virtual signal void property_hide (string prop_name);
		public virtual signal void property_show (string prop_name);
		public virtual signal void reset ();
		public virtual signal void set_capabilities (uint caps);
		public virtual signal void set_cursor_location (int x, int y, int w, int h);
		public virtual signal void set_surrounding_text (GLib.Object text, uint cursor_index, uint anchor_pos);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_engine_desc_get_type ()")]
	public class EngineDesc : IBus.Serializable {
		[CCode (has_construct_function = false)]
		public EngineDesc (string name, string longname, string description, string language, string license, string author, string icon, string layout);
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_hotkeys ();
		public unowned string get_icon ();
		public unowned string get_language ();
		public unowned string get_layout ();
		public unowned string get_license ();
		public unowned string get_longname ();
		public unowned string get_name ();
		public uint get_rank ();
		public unowned string get_setup ();
		public unowned string get_symbol ();
		public void output (GLib.StringBuilder output, int indent);
		public string author { get; construct; }
		public string description { get; construct; }
		public string hotkeys { get; construct; }
		public string icon { get; construct; }
		public string language { get; construct; }
		public string layout { get; construct; }
		public string license { get; construct; }
		public string longname { get; construct; }
		public string name { get; construct; }
		public uint rank { get; construct; }
		public string setup { get; construct; }
		public string symbol { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_factory_get_type ()")]
	public class Factory : IBus.Service {
		[CCode (has_construct_function = false)]
		public Factory (GLib.DBusConnection connection);
		public void add_engine (string engine_name, GLib.Type engine_type);
		[HasEmitter]
		public virtual signal unowned IBus.Engine create_engine (string engine_name);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_hotkey_profile_get_type ()")]
	public class HotkeyProfile : IBus.Serializable {
		[CCode (has_construct_function = false)]
		public HotkeyProfile ();
		public bool add_hotkey (uint keyval, uint modifiers, GLib.Quark event);
		public bool add_hotkey_from_string (string str, GLib.Quark event);
		public GLib.Quark filter_key_event (uint keyval, uint modifiers, uint prev_keyval, uint prev_modifiers, void* user_data);
		public GLib.Quark lookup_hotkey (uint keyval, uint modifiers);
		public bool remove_hotkey (uint keyval, uint modifiers);
		public bool remove_hotkey_by_event (GLib.Quark event);
		public virtual signal void trigger (uint event, void* user_data);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_input_context_get_type ()")]
	public class InputContext : IBus.Proxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		[CCode (has_construct_function = false)]
		public InputContext (string path, GLib.DBusConnection connection, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public InputContext.async_finish (GLib.AsyncResult res) throws GLib.Error;
		public void cancel_hand_writing (uint n_strokes);
		public void disable ();
		public void enable ();
		public void focus_in ();
		public void focus_out ();
		public unowned IBus.EngineDesc get_engine ();
		public async void get_engine_async (int timeout_msec, GLib.Cancellable? cancellable);
		public unowned IBus.EngineDesc get_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public static unowned IBus.InputContext get_input_context (string path, GLib.DBusConnection connection);
		public static async void get_input_context_async (string path, GLib.DBusConnection connection, GLib.Cancellable? cancellable);
		public static unowned IBus.InputContext get_input_context_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool is_enabled ();
		public async void is_enabled_async (int timeout_msec, GLib.Cancellable? cancellable);
		public bool is_enabled_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool needs_surrounding_text ();
		public static async void new_async (string path, GLib.DBusConnection connection, GLib.Cancellable? cancellable);
		public void process_hand_writing_event (double coordinates, uint coordinates_len);
		public bool process_key_event (uint32 keyval, uint32 keycode, uint32 state);
		public async void process_key_event_async (uint32 keyval, uint32 keycode, uint32 state, int timeout_msec, GLib.Cancellable? cancellable);
		public bool process_key_event_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public void property_activate (string prop_name, uint32 state);
		public void reset ();
		public void set_capabilities (uint32 capabilities);
		public void set_cursor_location (int32 x, int32 y, int32 w, int32 h);
		public void set_engine (string name);
		public void set_surrounding_text (IBus.Text text, uint32 cursor_pos, uint32 anchor_pos);
		public signal void commit_text (IBus.Text text);
		public signal void cursor_down_lookup_table ();
		public signal void cursor_up_lookup_table ();
		public signal void delete_surrounding_text (int offset, uint n_chars);
		public signal void disabled ();
		public signal void enabled ();
		public signal void forward_key_event (uint keyval, uint keycode, uint modifiers);
		public signal void hide_auxiliary_text ();
		public signal void hide_lookup_table ();
		public signal void hide_preedit_text ();
		public signal void page_down_lookup_table ();
		public signal void page_up_lookup_table ();
		public signal void register_properties (IBus.PropList props);
		public signal void show_auxiliary_text ();
		public signal void show_lookup_table ();
		public signal void show_preedit_text ();
		public signal void update_auxiliary_text (IBus.Text object, bool p0);
		public signal void update_lookup_table (IBus.LookupTable table, bool visible);
		public signal void update_preedit_text (IBus.Text text, uint cursor_pos, bool visible);
		public signal void update_property (IBus.Property prop);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_keymap_get_type ()")]
	public class Keymap : IBus.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak uint[] keymap;
		public weak string name;
		[CCode (has_construct_function = false)]
		public Keymap (string name);
		public uint lookup_keysym (uint16 keycode, uint32 state);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_lookup_table_get_type ()")]
	public class LookupTable : IBus.Serializable {
		public weak GLib.Array<void*> candidates;
		public uint cursor_pos;
		public bool cursor_visible;
		public weak GLib.Array<void*> labels;
		public int orientation;
		public uint page_size;
		public bool round;
		[CCode (has_construct_function = false)]
		public LookupTable (uint page_size, uint cursor_pos, bool cursor_visible, bool round);
		public void append_candidate (IBus.Text text);
		public void append_label (IBus.Text text);
		public void clear ();
		public bool cursor_down ();
		public bool cursor_up ();
		public unowned IBus.Text get_candidate (uint index);
		public uint get_cursor_in_page ();
		public uint get_cursor_pos ();
		public unowned IBus.Text get_label (uint index);
		public uint get_number_of_candidates ();
		public int get_orientation ();
		public uint get_page_size ();
		public bool is_cursor_visible ();
		public bool is_round ();
		public bool page_down ();
		public bool page_up ();
		public void set_cursor_pos (uint cursor_pos);
		public void set_cursor_visible (bool visible);
		public void set_label (uint index, IBus.Text text);
		public void set_orientation (int orientation);
		public void set_page_size (uint page_size);
		public void set_round (bool round);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_object_get_type ()")]
	public class Object : GLib.InitiallyUnowned {
		public uint32 flags;
		[CCode (has_construct_function = false)]
		public Object ();
		[HasEmitter]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_observed_path_get_type ()")]
	public class ObservedPath : IBus.Serializable {
		public bool is_dir;
		public bool is_exist;
		public long mtime;
		public weak string path;
		[CCode (has_construct_function = false)]
		public ObservedPath (string path, bool fill_stat);
		public bool check_modification ();
		public void output (GLib.StringBuilder output, int indent);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_panel_service_get_type ()")]
	public class PanelService : IBus.Service {
		[CCode (has_construct_function = false)]
		public PanelService (GLib.DBusConnection connection);
		public void candidate_clicked (uint index, uint button, uint state);
		public void cursor_down ();
		public void cursor_up ();
		public void page_down ();
		public void page_up ();
		public void property_activate (string prop_name, uint prop_state);
		public void property_hide (string prop_name);
		public void property_show (string prop_name);
		public virtual signal void cursor_down_lookup_table ();
		public virtual signal void cursor_up_lookup_table ();
		public virtual signal void focus_in (string input_context_path);
		public virtual signal void focus_out (string input_context_path);
		public virtual signal void hide_auxiliary_text ();
		public virtual signal void hide_language_bar ();
		public virtual signal void hide_lookup_table ();
		public virtual signal void hide_preedit_text ();
		public virtual signal void page_down_lookup_table ();
		public virtual signal void page_up_lookup_table ();
		public virtual signal void register_properties (IBus.PropList prop_list);
		public virtual signal void reset ();
		public virtual signal void set_cursor_location (int x, int y, int w, int h);
		public virtual signal void show_auxiliary_text ();
		public virtual signal void show_language_bar ();
		public virtual signal void show_lookup_table ();
		public virtual signal void show_preedit_text ();
		public virtual signal void start_setup ();
		public virtual signal void state_changed ();
		public virtual signal void update_auxiliary_text (IBus.Text text, bool visible);
		public virtual signal void update_lookup_table (IBus.LookupTable lookup_table, bool visible);
		public virtual signal void update_preedit_text (IBus.Text text, uint cursor_pos, bool visible);
		public virtual signal void update_property (IBus.Property prop);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_prop_list_get_type ()")]
	public class PropList : IBus.Serializable {
		public weak GLib.Array<void*> properties;
		[CCode (has_construct_function = false)]
		public PropList ();
		public void append (IBus.Property prop);
		public unowned IBus.Property @get (uint index);
		public bool update_property (IBus.Property prop);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_property_get_type ()")]
	public class Property : IBus.Serializable {
		[CCode (has_construct_function = false)]
		public Property (string key, IBus.PropType type, IBus.Text label, string? icon, IBus.Text tooltip, bool sensitive, bool visible, IBus.PropState state, IBus.PropList? prop_list);
		public unowned string get_icon ();
		public unowned string get_key ();
		public unowned IBus.Text get_label ();
		public IBus.PropType get_prop_type ();
		public bool get_sensitive ();
		public IBus.PropState get_state ();
		public unowned IBus.PropList get_sub_props ();
		public unowned IBus.Text get_tooltip ();
		public bool get_visible ();
		public void set_icon (string icon);
		public void set_label (IBus.Text label);
		public void set_sensitive (bool sensitive);
		public void set_state (IBus.PropState state);
		public void set_sub_props (IBus.PropList prop_list);
		public void set_tooltip (IBus.Text tooltip);
		public void set_visible (bool visible);
		public bool update (IBus.Property prop_update);
		public string icon { get; set; }
		public string key { get; construct; }
		public IBus.Text label { get; set construct; }
		public IBus.PropType prop_type { get; construct; }
		public bool sensitive { get; set; }
		public IBus.PropState state { get; set; }
		public IBus.PropList sub_props { get; set; }
		public IBus.Text tooltip { get; set; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_proxy_get_type ()")]
	public class Proxy : GLib.DBusProxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		public uint32 flags;
		public bool own;
		[CCode (has_construct_function = false)]
		protected Proxy ();
		[HasEmitter]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_serializable_get_type ()")]
	public class Serializable : IBus.Object {
		[CCode (has_construct_function = false)]
		public Serializable ();
		[NoWrapper]
		public virtual bool copy (IBus.Serializable src);
		[NoWrapper]
		public virtual int deserialize (GLib.Variant variant);
		public GLib.Variant get_qattachment (GLib.Quark key);
		public void remove_qattachment (GLib.Quark key);
		[NoWrapper]
		public virtual bool serialize (GLib.VariantBuilder builder);
		public void set_qattachment (GLib.Quark key, GLib.Variant value);
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_service_get_type ()")]
	public class Service : IBus.Object {
		[CCode (has_construct_function = false)]
		public Service (GLib.DBusConnection connection, string path);
		public bool emit_signal (string dest_bus_name, string interface_name, string signal_name, GLib.Variant parameters) throws GLib.Error;
		public unowned GLib.DBusConnection get_connection ();
		public unowned string get_object_path ();
		public bool register (GLib.DBusConnection connection) throws GLib.Error;
		[NoWrapper]
		public virtual GLib.Variant service_get_property (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name) throws GLib.Error;
		[NoWrapper]
		public virtual void service_method_call (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string method_name, GLib.Variant parameters, GLib.DBusMethodInvocation invocation);
		[NoWrapper]
		public virtual bool service_set_property (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name, GLib.Variant value) throws GLib.Error;
		public void unregister (GLib.DBusConnection connection);
		public GLib.DBusConnection connection { get; construct; }
		public string object_path { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h", type_id = "ibus_text_get_type ()")]
	public class Text : IBus.Serializable {
		public weak IBus.AttrList attrs;
		public bool is_static;
		public weak string text;
		[CCode (has_construct_function = false)]
		protected Text ();
		public void append_attribute (uint type, uint value, uint start_index, int end_index);
		[CCode (cname = "ibus_text_new_from_static_string", has_construct_function = false)]
		public Text.from_static_string (string str);
		[CCode (has_construct_function = false)]
		public Text.from_string (string str);
		[CCode (has_construct_function = false)]
		public Text.from_ucs4 (unichar str);
		[CCode (has_construct_function = false)]
		public Text.from_unichar (unichar c);
		public unowned IBus.AttrList get_attributes ();
		public uint get_length ();
		public unowned string get_text ();
		public void set_attributes (IBus.AttrList attrs);
	}
	[CCode (cheader_filename = "ibus.h", has_type_id = false)]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ATTR_TYPE_")]
	public enum AttrType {
		UNDERLINE,
		FOREGROUND,
		BACKGROUND
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ATTR_UNDERLINE_")]
	public enum AttrUnderline {
		NONE,
		SINGLE,
		DOUBLE,
		LOW,
		ERROR;
		public static unowned IBus.Attribute @new (uint underline_type, uint start_index, uint end_index);
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_NAME_FLAG_")]
	[Flags]
	public enum BusNameFlag {
		ALLOW_REPLACEMENT,
		REPLACE_EXISTING,
		DO_NOT_QUEUE
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_REQUEST_NAME_REPLY_")]
	public enum BusRequestNameReply {
		PRIMARY_OWNER,
		IN_QUEUE,
		EXISTS,
		ALREADY_OWNER
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_START_REPLY_")]
	public enum BusStartServiceByNameReply {
		SUCCESS,
		ALREADY_RUNNING
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_CAP_")]
	[Flags]
	public enum Capabilite {
		PREEDIT_TEXT,
		AUXILIARY_TEXT,
		LOOKUP_TABLE,
		FOCUS,
		PROPERTY,
		SURROUNDING_TEXT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ERROR_NO_")]
	public enum Error {
		ENGINE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		HANDLED_MASK,
		FORWARD_MASK,
		IGNORED_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_")]
	[Flags]
	public enum ObjectFlags {
		IN_DESTRUCTION,
		DESTROYED,
		RESERVED_1,
		RESERVED_2
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ORIENTATION_")]
	public enum Orientation {
		HORIZONTAL,
		VERTICAL,
		SYSTEM
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ENGINE_PREEDIT_")]
	public enum PreeditFocusMode {
		CLEAR,
		COMMIT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "PROP_STATE_")]
	public enum PropState {
		UNCHECKED,
		CHECKED,
		INCONSISTENT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "PROP_TYPE_")]
	public enum PropType {
		NORMAL,
		TOGGLE,
		RADIO,
		MENU,
		SEPARATOR
	}
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate void FreeFunc (void* object);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate void ObjectDestroyFunc (IBus.Object arg0);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate bool SerializableCopyFunc (IBus.Serializable dest, IBus.Serializable src);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate int SerializableDeserializeFunc (IBus.Serializable serializable, GLib.Variant variant);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate bool SerializableSerializeFunc (IBus.Serializable serializable, GLib.VariantBuilder builder);
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_0")]
	public const int @0;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_1")]
	public const int @1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_2")]
	public const int @2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3")]
	public const int @3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_AltCursor")]
	public const int @3270_AltCursor;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Attn")]
	public const int @3270_Attn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_BackTab")]
	public const int @3270_BackTab;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_ChangeScreen")]
	public const int @3270_ChangeScreen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Copy")]
	public const int @3270_Copy;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_CursorBlink")]
	public const int @3270_CursorBlink;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_CursorSelect")]
	public const int @3270_CursorSelect;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_DeleteWord")]
	public const int @3270_DeleteWord;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Duplicate")]
	public const int @3270_Duplicate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Enter")]
	public const int @3270_Enter;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_EraseEOF")]
	public const int @3270_EraseEOF;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_EraseInput")]
	public const int @3270_EraseInput;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_ExSelect")]
	public const int @3270_ExSelect;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_FieldMark")]
	public const int @3270_FieldMark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Ident")]
	public const int @3270_Ident;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Jump")]
	public const int @3270_Jump;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_KeyClick")]
	public const int @3270_KeyClick;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Left2")]
	public const int @3270_Left2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_PA1")]
	public const int @3270_PA1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_PA2")]
	public const int @3270_PA2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_PA3")]
	public const int @3270_PA3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Play")]
	public const int @3270_Play;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_PrintScreen")]
	public const int @3270_PrintScreen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Quit")]
	public const int @3270_Quit;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Record")]
	public const int @3270_Record;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Reset")]
	public const int @3270_Reset;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Right2")]
	public const int @3270_Right2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Rule")]
	public const int @3270_Rule;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Setup")]
	public const int @3270_Setup;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_3270_Test")]
	public const int @3270_Test;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_4")]
	public const int @4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_5")]
	public const int @5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_6")]
	public const int @6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_7")]
	public const int @7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_8")]
	public const int @8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_9")]
	public const int @9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_A")]
	public const int A;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_AE")]
	public const int AE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Aacute")]
	public const int Aacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abelowdot")]
	public const int Abelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abreve")]
	public const int Abreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abreveacute")]
	public const int Abreveacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abrevebelowdot")]
	public const int Abrevebelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abrevegrave")]
	public const int Abrevegrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abrevehook")]
	public const int Abrevehook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Abrevetilde")]
	public const int Abrevetilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_AccessX_Enable")]
	public const int AccessX_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_AccessX_Feedback_Enable")]
	public const int AccessX_Feedback_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflex")]
	public const int Acircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflexacute")]
	public const int Acircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflexbelowdot")]
	public const int Acircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflexgrave")]
	public const int Acircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflexhook")]
	public const int Acircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Acircumflextilde")]
	public const int Acircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Adiaeresis")]
	public const int Adiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Agrave")]
	public const int Agrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ahook")]
	public const int Ahook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Alt_L")]
	public const int Alt_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Alt_R")]
	public const int Alt_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Amacron")]
	public const int Amacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Aogonek")]
	public const int Aogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_0")]
	public const int Arabic_0;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_1")]
	public const int Arabic_1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_2")]
	public const int Arabic_2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_3")]
	public const int Arabic_3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_4")]
	public const int Arabic_4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_5")]
	public const int Arabic_5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_6")]
	public const int Arabic_6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_7")]
	public const int Arabic_7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_8")]
	public const int Arabic_8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_9")]
	public const int Arabic_9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_ain")]
	public const int Arabic_ain;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_alef")]
	public const int Arabic_alef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_alefmaksura")]
	public const int Arabic_alefmaksura;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_beh")]
	public const int Arabic_beh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_comma")]
	public const int Arabic_comma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_dad")]
	public const int Arabic_dad;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_dal")]
	public const int Arabic_dal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_damma")]
	public const int Arabic_damma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_dammatan")]
	public const int Arabic_dammatan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_ddal")]
	public const int Arabic_ddal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_farsi_yeh")]
	public const int Arabic_farsi_yeh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_fatha")]
	public const int Arabic_fatha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_fathatan")]
	public const int Arabic_fathatan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_feh")]
	public const int Arabic_feh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_fullstop")]
	public const int Arabic_fullstop;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_gaf")]
	public const int Arabic_gaf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_ghain")]
	public const int Arabic_ghain;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_ha")]
	public const int Arabic_ha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hah")]
	public const int Arabic_hah;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamza")]
	public const int Arabic_hamza;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamza_above")]
	public const int Arabic_hamza_above;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamza_below")]
	public const int Arabic_hamza_below;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamzaonalef")]
	public const int Arabic_hamzaonalef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamzaonwaw")]
	public const int Arabic_hamzaonwaw;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamzaonyeh")]
	public const int Arabic_hamzaonyeh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_hamzaunderalef")]
	public const int Arabic_hamzaunderalef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_heh")]
	public const int Arabic_heh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_heh_doachashmee")]
	public const int Arabic_heh_doachashmee;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_heh_goal")]
	public const int Arabic_heh_goal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_jeem")]
	public const int Arabic_jeem;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_jeh")]
	public const int Arabic_jeh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_kaf")]
	public const int Arabic_kaf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_kasra")]
	public const int Arabic_kasra;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_kasratan")]
	public const int Arabic_kasratan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_keheh")]
	public const int Arabic_keheh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_khah")]
	public const int Arabic_khah;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_lam")]
	public const int Arabic_lam;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_madda_above")]
	public const int Arabic_madda_above;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_maddaonalef")]
	public const int Arabic_maddaonalef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_meem")]
	public const int Arabic_meem;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_noon")]
	public const int Arabic_noon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_noon_ghunna")]
	public const int Arabic_noon_ghunna;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_peh")]
	public const int Arabic_peh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_percent")]
	public const int Arabic_percent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_qaf")]
	public const int Arabic_qaf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_question_mark")]
	public const int Arabic_question_mark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_ra")]
	public const int Arabic_ra;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_rreh")]
	public const int Arabic_rreh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_sad")]
	public const int Arabic_sad;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_seen")]
	public const int Arabic_seen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_semicolon")]
	public const int Arabic_semicolon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_shadda")]
	public const int Arabic_shadda;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_sheen")]
	public const int Arabic_sheen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_sukun")]
	public const int Arabic_sukun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_superscript_alef")]
	public const int Arabic_superscript_alef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_switch")]
	public const int Arabic_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_tah")]
	public const int Arabic_tah;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_tatweel")]
	public const int Arabic_tatweel;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_tcheh")]
	public const int Arabic_tcheh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_teh")]
	public const int Arabic_teh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_tehmarbuta")]
	public const int Arabic_tehmarbuta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_thal")]
	public const int Arabic_thal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_theh")]
	public const int Arabic_theh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_tteh")]
	public const int Arabic_tteh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_veh")]
	public const int Arabic_veh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_waw")]
	public const int Arabic_waw;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_yeh")]
	public const int Arabic_yeh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_yeh_baree")]
	public const int Arabic_yeh_baree;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_zah")]
	public const int Arabic_zah;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Arabic_zain")]
	public const int Arabic_zain;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Aring")]
	public const int Aring;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_AT")]
	public const int Armenian_AT;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_AYB")]
	public const int Armenian_AYB;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_BEN")]
	public const int Armenian_BEN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_CHA")]
	public const int Armenian_CHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_DA")]
	public const int Armenian_DA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_DZA")]
	public const int Armenian_DZA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_E")]
	public const int Armenian_E;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_FE")]
	public const int Armenian_FE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_GHAT")]
	public const int Armenian_GHAT;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_GIM")]
	public const int Armenian_GIM;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_HI")]
	public const int Armenian_HI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_HO")]
	public const int Armenian_HO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_INI")]
	public const int Armenian_INI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_JE")]
	public const int Armenian_JE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_KE")]
	public const int Armenian_KE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_KEN")]
	public const int Armenian_KEN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_KHE")]
	public const int Armenian_KHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_LYUN")]
	public const int Armenian_LYUN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_MEN")]
	public const int Armenian_MEN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_NU")]
	public const int Armenian_NU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_O")]
	public const int Armenian_O;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_PE")]
	public const int Armenian_PE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_PYUR")]
	public const int Armenian_PYUR;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_RA")]
	public const int Armenian_RA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_RE")]
	public const int Armenian_RE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_SE")]
	public const int Armenian_SE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_SHA")]
	public const int Armenian_SHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_TCHE")]
	public const int Armenian_TCHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_TO")]
	public const int Armenian_TO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_TSA")]
	public const int Armenian_TSA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_TSO")]
	public const int Armenian_TSO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_TYUN")]
	public const int Armenian_TYUN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_VEV")]
	public const int Armenian_VEV;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_VO")]
	public const int Armenian_VO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_VYUN")]
	public const int Armenian_VYUN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_YECH")]
	public const int Armenian_YECH;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ZA")]
	public const int Armenian_ZA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ZHE")]
	public const int Armenian_ZHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_accent")]
	public const int Armenian_accent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_amanak")]
	public const int Armenian_amanak;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_apostrophe")]
	public const int Armenian_apostrophe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_at")]
	public const int Armenian_at;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ayb")]
	public const int Armenian_ayb;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ben")]
	public const int Armenian_ben;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_but")]
	public const int Armenian_but;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_cha")]
	public const int Armenian_cha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_da")]
	public const int Armenian_da;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_dza")]
	public const int Armenian_dza;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_e")]
	public const int Armenian_e;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_exclam")]
	public const int Armenian_exclam;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_fe")]
	public const int Armenian_fe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_full_stop")]
	public const int Armenian_full_stop;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ghat")]
	public const int Armenian_ghat;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_gim")]
	public const int Armenian_gim;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_hi")]
	public const int Armenian_hi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ho")]
	public const int Armenian_ho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_hyphen")]
	public const int Armenian_hyphen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ini")]
	public const int Armenian_ini;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_je")]
	public const int Armenian_je;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ke")]
	public const int Armenian_ke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ken")]
	public const int Armenian_ken;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_khe")]
	public const int Armenian_khe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ligature_ew")]
	public const int Armenian_ligature_ew;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_lyun")]
	public const int Armenian_lyun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_men")]
	public const int Armenian_men;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_nu")]
	public const int Armenian_nu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_o")]
	public const int Armenian_o;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_paruyk")]
	public const int Armenian_paruyk;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_pe")]
	public const int Armenian_pe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_pyur")]
	public const int Armenian_pyur;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_question")]
	public const int Armenian_question;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_ra")]
	public const int Armenian_ra;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_re")]
	public const int Armenian_re;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_se")]
	public const int Armenian_se;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_separation_mark")]
	public const int Armenian_separation_mark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_sha")]
	public const int Armenian_sha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_shesht")]
	public const int Armenian_shesht;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_tche")]
	public const int Armenian_tche;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_to")]
	public const int Armenian_to;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_tsa")]
	public const int Armenian_tsa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_tso")]
	public const int Armenian_tso;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_tyun")]
	public const int Armenian_tyun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_verjaket")]
	public const int Armenian_verjaket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_vev")]
	public const int Armenian_vev;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_vo")]
	public const int Armenian_vo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_vyun")]
	public const int Armenian_vyun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_yech")]
	public const int Armenian_yech;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_yentamna")]
	public const int Armenian_yentamna;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_za")]
	public const int Armenian_za;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Armenian_zhe")]
	public const int Armenian_zhe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Atilde")]
	public const int Atilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_AudibleBell_Enable")]
	public const int AudibleBell_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_B")]
	public const int B;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Babovedot")]
	public const int Babovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_BackSpace")]
	public const int BackSpace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Begin")]
	public const int Begin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_BounceKeys_Enable")]
	public const int BounceKeys_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Break")]
	public const int Break;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Byelorussian_SHORTU")]
	public const int Byelorussian_SHORTU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Byelorussian_shortu")]
	public const int Byelorussian_shortu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_C")]
	public const int C;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cabovedot")]
	public const int Cabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cacute")]
	public const int Cacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cancel")]
	public const int Cancel;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Caps_Lock")]
	public const int Caps_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ccaron")]
	public const int Ccaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ccedilla")]
	public const int Ccedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ccircumflex")]
	public const int Ccircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Clear")]
	public const int Clear;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Codeinput")]
	public const int Codeinput;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ColonSign")]
	public const int ColonSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Control_L")]
	public const int Control_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Control_R")]
	public const int Control_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_CruzeiroSign")]
	public const int CruzeiroSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_A")]
	public const int Cyrillic_A;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_BE")]
	public const int Cyrillic_BE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_CHE")]
	public const int Cyrillic_CHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_CHE_descender")]
	public const int Cyrillic_CHE_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_CHE_vertstroke")]
	public const int Cyrillic_CHE_vertstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_DE")]
	public const int Cyrillic_DE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_DZHE")]
	public const int Cyrillic_DZHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_E")]
	public const int Cyrillic_E;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_EF")]
	public const int Cyrillic_EF;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_EL")]
	public const int Cyrillic_EL;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_EM")]
	public const int Cyrillic_EM;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_EN")]
	public const int Cyrillic_EN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_EN_descender")]
	public const int Cyrillic_EN_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ER")]
	public const int Cyrillic_ER;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ES")]
	public const int Cyrillic_ES;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_GHE")]
	public const int Cyrillic_GHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_GHE_bar")]
	public const int Cyrillic_GHE_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_HA")]
	public const int Cyrillic_HA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_HARDSIGN")]
	public const int Cyrillic_HARDSIGN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_HA_descender")]
	public const int Cyrillic_HA_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_I")]
	public const int Cyrillic_I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_IE")]
	public const int Cyrillic_IE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_IO")]
	public const int Cyrillic_IO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_I_macron")]
	public const int Cyrillic_I_macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_JE")]
	public const int Cyrillic_JE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_KA")]
	public const int Cyrillic_KA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_KA_descender")]
	public const int Cyrillic_KA_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_KA_vertstroke")]
	public const int Cyrillic_KA_vertstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_LJE")]
	public const int Cyrillic_LJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_NJE")]
	public const int Cyrillic_NJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_O")]
	public const int Cyrillic_O;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_O_bar")]
	public const int Cyrillic_O_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_PE")]
	public const int Cyrillic_PE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SCHWA")]
	public const int Cyrillic_SCHWA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SHA")]
	public const int Cyrillic_SHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SHCHA")]
	public const int Cyrillic_SHCHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SHHA")]
	public const int Cyrillic_SHHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SHORTI")]
	public const int Cyrillic_SHORTI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_SOFTSIGN")]
	public const int Cyrillic_SOFTSIGN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_TE")]
	public const int Cyrillic_TE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_TSE")]
	public const int Cyrillic_TSE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_U")]
	public const int Cyrillic_U;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_U_macron")]
	public const int Cyrillic_U_macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_U_straight")]
	public const int Cyrillic_U_straight;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_U_straight_bar")]
	public const int Cyrillic_U_straight_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_VE")]
	public const int Cyrillic_VE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_YA")]
	public const int Cyrillic_YA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_YERU")]
	public const int Cyrillic_YERU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_YU")]
	public const int Cyrillic_YU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ZE")]
	public const int Cyrillic_ZE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ZHE")]
	public const int Cyrillic_ZHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ZHE_descender")]
	public const int Cyrillic_ZHE_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_a")]
	public const int Cyrillic_a;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_be")]
	public const int Cyrillic_be;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_che")]
	public const int Cyrillic_che;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_che_descender")]
	public const int Cyrillic_che_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_che_vertstroke")]
	public const int Cyrillic_che_vertstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_de")]
	public const int Cyrillic_de;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_dzhe")]
	public const int Cyrillic_dzhe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_e")]
	public const int Cyrillic_e;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ef")]
	public const int Cyrillic_ef;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_el")]
	public const int Cyrillic_el;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_em")]
	public const int Cyrillic_em;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_en")]
	public const int Cyrillic_en;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_en_descender")]
	public const int Cyrillic_en_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_er")]
	public const int Cyrillic_er;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_es")]
	public const int Cyrillic_es;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ghe")]
	public const int Cyrillic_ghe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ghe_bar")]
	public const int Cyrillic_ghe_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ha")]
	public const int Cyrillic_ha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ha_descender")]
	public const int Cyrillic_ha_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_hardsign")]
	public const int Cyrillic_hardsign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_i")]
	public const int Cyrillic_i;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_i_macron")]
	public const int Cyrillic_i_macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ie")]
	public const int Cyrillic_ie;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_io")]
	public const int Cyrillic_io;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_je")]
	public const int Cyrillic_je;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ka")]
	public const int Cyrillic_ka;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ka_descender")]
	public const int Cyrillic_ka_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ka_vertstroke")]
	public const int Cyrillic_ka_vertstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_lje")]
	public const int Cyrillic_lje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_nje")]
	public const int Cyrillic_nje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_o")]
	public const int Cyrillic_o;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_o_bar")]
	public const int Cyrillic_o_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_pe")]
	public const int Cyrillic_pe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_schwa")]
	public const int Cyrillic_schwa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_sha")]
	public const int Cyrillic_sha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_shcha")]
	public const int Cyrillic_shcha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_shha")]
	public const int Cyrillic_shha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_shorti")]
	public const int Cyrillic_shorti;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_softsign")]
	public const int Cyrillic_softsign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_te")]
	public const int Cyrillic_te;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_tse")]
	public const int Cyrillic_tse;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_u")]
	public const int Cyrillic_u;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_u_macron")]
	public const int Cyrillic_u_macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_u_straight")]
	public const int Cyrillic_u_straight;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_u_straight_bar")]
	public const int Cyrillic_u_straight_bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ve")]
	public const int Cyrillic_ve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ya")]
	public const int Cyrillic_ya;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_yeru")]
	public const int Cyrillic_yeru;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_yu")]
	public const int Cyrillic_yu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_ze")]
	public const int Cyrillic_ze;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_zhe")]
	public const int Cyrillic_zhe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Cyrillic_zhe_descender")]
	public const int Cyrillic_zhe_descender;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_D")]
	public const int D;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Dabovedot")]
	public const int Dabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Dcaron")]
	public const int Dcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Delete")]
	public const int Delete;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_DongSign")]
	public const int DongSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Down")]
	public const int Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Dstroke")]
	public const int Dstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_E")]
	public const int E;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ENG")]
	public const int ENG;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ETH")]
	public const int ETH;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eabovedot")]
	public const int Eabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eacute")]
	public const int Eacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ebelowdot")]
	public const int Ebelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecaron")]
	public const int Ecaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflex")]
	public const int Ecircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflexacute")]
	public const int Ecircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflexbelowdot")]
	public const int Ecircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflexgrave")]
	public const int Ecircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflexhook")]
	public const int Ecircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ecircumflextilde")]
	public const int Ecircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_EcuSign")]
	public const int EcuSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ediaeresis")]
	public const int Ediaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Egrave")]
	public const int Egrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ehook")]
	public const int Ehook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eisu_Shift")]
	public const int Eisu_Shift;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eisu_toggle")]
	public const int Eisu_toggle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Emacron")]
	public const int Emacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_End")]
	public const int End;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eogonek")]
	public const int Eogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Escape")]
	public const int Escape;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Eth")]
	public const int Eth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Etilde")]
	public const int Etilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_EuroSign")]
	public const int EuroSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Execute")]
	public const int Execute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F")]
	public const int F;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F1")]
	public const int F1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F10")]
	public const int F10;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F11")]
	public const int F11;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F12")]
	public const int F12;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F13")]
	public const int F13;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F14")]
	public const int F14;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F15")]
	public const int F15;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F16")]
	public const int F16;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F17")]
	public const int F17;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F18")]
	public const int F18;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F19")]
	public const int F19;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F2")]
	public const int F2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F20")]
	public const int F20;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F21")]
	public const int F21;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F22")]
	public const int F22;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F23")]
	public const int F23;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F24")]
	public const int F24;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F25")]
	public const int F25;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F26")]
	public const int F26;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F27")]
	public const int F27;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F28")]
	public const int F28;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F29")]
	public const int F29;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F3")]
	public const int F3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F30")]
	public const int F30;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F31")]
	public const int F31;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F32")]
	public const int F32;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F33")]
	public const int F33;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F34")]
	public const int F34;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F35")]
	public const int F35;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F4")]
	public const int F4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F5")]
	public const int F5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F6")]
	public const int F6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F7")]
	public const int F7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F8")]
	public const int F8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_F9")]
	public const int F9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_FFrancSign")]
	public const int FFrancSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Fabovedot")]
	public const int Fabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_0")]
	public const int Farsi_0;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_1")]
	public const int Farsi_1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_2")]
	public const int Farsi_2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_3")]
	public const int Farsi_3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_4")]
	public const int Farsi_4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_5")]
	public const int Farsi_5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_6")]
	public const int Farsi_6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_7")]
	public const int Farsi_7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_8")]
	public const int Farsi_8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_9")]
	public const int Farsi_9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Farsi_yeh")]
	public const int Farsi_yeh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Find")]
	public const int Find;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_First_Virtual_Screen")]
	public const int First_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_G")]
	public const int G;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Gabovedot")]
	public const int Gabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Gbreve")]
	public const int Gbreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Gcaron")]
	public const int Gcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Gcedilla")]
	public const int Gcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Gcircumflex")]
	public const int Gcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_an")]
	public const int Georgian_an;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_ban")]
	public const int Georgian_ban;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_can")]
	public const int Georgian_can;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_char")]
	public const int Georgian_char;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_chin")]
	public const int Georgian_chin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_cil")]
	public const int Georgian_cil;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_don")]
	public const int Georgian_don;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_en")]
	public const int Georgian_en;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_fi")]
	public const int Georgian_fi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_gan")]
	public const int Georgian_gan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_ghan")]
	public const int Georgian_ghan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_hae")]
	public const int Georgian_hae;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_har")]
	public const int Georgian_har;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_he")]
	public const int Georgian_he;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_hie")]
	public const int Georgian_hie;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_hoe")]
	public const int Georgian_hoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_in")]
	public const int Georgian_in;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_jhan")]
	public const int Georgian_jhan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_jil")]
	public const int Georgian_jil;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_kan")]
	public const int Georgian_kan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_khar")]
	public const int Georgian_khar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_las")]
	public const int Georgian_las;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_man")]
	public const int Georgian_man;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_nar")]
	public const int Georgian_nar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_on")]
	public const int Georgian_on;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_par")]
	public const int Georgian_par;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_phar")]
	public const int Georgian_phar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_qar")]
	public const int Georgian_qar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_rae")]
	public const int Georgian_rae;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_san")]
	public const int Georgian_san;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_shin")]
	public const int Georgian_shin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_tan")]
	public const int Georgian_tan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_tar")]
	public const int Georgian_tar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_un")]
	public const int Georgian_un;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_vin")]
	public const int Georgian_vin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_we")]
	public const int Georgian_we;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_xan")]
	public const int Georgian_xan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_zen")]
	public const int Georgian_zen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Georgian_zhar")]
	public const int Georgian_zhar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_ALPHA")]
	public const int Greek_ALPHA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_ALPHAaccent")]
	public const int Greek_ALPHAaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_BETA")]
	public const int Greek_BETA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_CHI")]
	public const int Greek_CHI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_DELTA")]
	public const int Greek_DELTA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_EPSILON")]
	public const int Greek_EPSILON;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_EPSILONaccent")]
	public const int Greek_EPSILONaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_ETA")]
	public const int Greek_ETA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_ETAaccent")]
	public const int Greek_ETAaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_GAMMA")]
	public const int Greek_GAMMA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_IOTA")]
	public const int Greek_IOTA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_IOTAaccent")]
	public const int Greek_IOTAaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_IOTAdiaeresis")]
	public const int Greek_IOTAdiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_IOTAdieresis")]
	public const int Greek_IOTAdieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_KAPPA")]
	public const int Greek_KAPPA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_LAMBDA")]
	public const int Greek_LAMBDA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_LAMDA")]
	public const int Greek_LAMDA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_MU")]
	public const int Greek_MU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_NU")]
	public const int Greek_NU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_OMEGA")]
	public const int Greek_OMEGA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_OMEGAaccent")]
	public const int Greek_OMEGAaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_OMICRON")]
	public const int Greek_OMICRON;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_OMICRONaccent")]
	public const int Greek_OMICRONaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_PHI")]
	public const int Greek_PHI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_PI")]
	public const int Greek_PI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_PSI")]
	public const int Greek_PSI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_RHO")]
	public const int Greek_RHO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_SIGMA")]
	public const int Greek_SIGMA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_TAU")]
	public const int Greek_TAU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_THETA")]
	public const int Greek_THETA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_UPSILON")]
	public const int Greek_UPSILON;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_UPSILONaccent")]
	public const int Greek_UPSILONaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_UPSILONdieresis")]
	public const int Greek_UPSILONdieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_XI")]
	public const int Greek_XI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_ZETA")]
	public const int Greek_ZETA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_accentdieresis")]
	public const int Greek_accentdieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_alpha")]
	public const int Greek_alpha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_alphaaccent")]
	public const int Greek_alphaaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_beta")]
	public const int Greek_beta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_chi")]
	public const int Greek_chi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_delta")]
	public const int Greek_delta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_epsilon")]
	public const int Greek_epsilon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_epsilonaccent")]
	public const int Greek_epsilonaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_eta")]
	public const int Greek_eta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_etaaccent")]
	public const int Greek_etaaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_finalsmallsigma")]
	public const int Greek_finalsmallsigma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_gamma")]
	public const int Greek_gamma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_horizbar")]
	public const int Greek_horizbar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_iota")]
	public const int Greek_iota;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_iotaaccent")]
	public const int Greek_iotaaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_iotaaccentdieresis")]
	public const int Greek_iotaaccentdieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_iotadieresis")]
	public const int Greek_iotadieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_kappa")]
	public const int Greek_kappa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_lambda")]
	public const int Greek_lambda;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_lamda")]
	public const int Greek_lamda;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_mu")]
	public const int Greek_mu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_nu")]
	public const int Greek_nu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_omega")]
	public const int Greek_omega;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_omegaaccent")]
	public const int Greek_omegaaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_omicron")]
	public const int Greek_omicron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_omicronaccent")]
	public const int Greek_omicronaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_phi")]
	public const int Greek_phi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_pi")]
	public const int Greek_pi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_psi")]
	public const int Greek_psi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_rho")]
	public const int Greek_rho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_sigma")]
	public const int Greek_sigma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_switch")]
	public const int Greek_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_tau")]
	public const int Greek_tau;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_theta")]
	public const int Greek_theta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_upsilon")]
	public const int Greek_upsilon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_upsilonaccent")]
	public const int Greek_upsilonaccent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_upsilonaccentdieresis")]
	public const int Greek_upsilonaccentdieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_upsilondieresis")]
	public const int Greek_upsilondieresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_xi")]
	public const int Greek_xi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Greek_zeta")]
	public const int Greek_zeta;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_H")]
	public const int H;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul")]
	public const int Hangul;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_A")]
	public const int Hangul_A;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_AE")]
	public const int Hangul_AE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_AraeA")]
	public const int Hangul_AraeA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_AraeAE")]
	public const int Hangul_AraeAE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Banja")]
	public const int Hangul_Banja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Cieuc")]
	public const int Hangul_Cieuc;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Codeinput")]
	public const int Hangul_Codeinput;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Dikeud")]
	public const int Hangul_Dikeud;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_E")]
	public const int Hangul_E;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_EO")]
	public const int Hangul_EO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_EU")]
	public const int Hangul_EU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_End")]
	public const int Hangul_End;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Hanja")]
	public const int Hangul_Hanja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Hieuh")]
	public const int Hangul_Hieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_I")]
	public const int Hangul_I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Ieung")]
	public const int Hangul_Ieung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Cieuc")]
	public const int Hangul_J_Cieuc;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Dikeud")]
	public const int Hangul_J_Dikeud;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Hieuh")]
	public const int Hangul_J_Hieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Ieung")]
	public const int Hangul_J_Ieung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Jieuj")]
	public const int Hangul_J_Jieuj;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Khieuq")]
	public const int Hangul_J_Khieuq;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Kiyeog")]
	public const int Hangul_J_Kiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_KiyeogSios")]
	public const int Hangul_J_KiyeogSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_KkogjiDalrinIeung")]
	public const int Hangul_J_KkogjiDalrinIeung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Mieum")]
	public const int Hangul_J_Mieum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Nieun")]
	public const int Hangul_J_Nieun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_NieunHieuh")]
	public const int Hangul_J_NieunHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_NieunJieuj")]
	public const int Hangul_J_NieunJieuj;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_PanSios")]
	public const int Hangul_J_PanSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Phieuf")]
	public const int Hangul_J_Phieuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Pieub")]
	public const int Hangul_J_Pieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_PieubSios")]
	public const int Hangul_J_PieubSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Rieul")]
	public const int Hangul_J_Rieul;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulHieuh")]
	public const int Hangul_J_RieulHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulKiyeog")]
	public const int Hangul_J_RieulKiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulMieum")]
	public const int Hangul_J_RieulMieum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulPhieuf")]
	public const int Hangul_J_RieulPhieuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulPieub")]
	public const int Hangul_J_RieulPieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulSios")]
	public const int Hangul_J_RieulSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_RieulTieut")]
	public const int Hangul_J_RieulTieut;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Sios")]
	public const int Hangul_J_Sios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_SsangKiyeog")]
	public const int Hangul_J_SsangKiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_SsangSios")]
	public const int Hangul_J_SsangSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_Tieut")]
	public const int Hangul_J_Tieut;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_J_YeorinHieuh")]
	public const int Hangul_J_YeorinHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Jamo")]
	public const int Hangul_Jamo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Jeonja")]
	public const int Hangul_Jeonja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Jieuj")]
	public const int Hangul_Jieuj;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Khieuq")]
	public const int Hangul_Khieuq;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Kiyeog")]
	public const int Hangul_Kiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_KiyeogSios")]
	public const int Hangul_KiyeogSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_KkogjiDalrinIeung")]
	public const int Hangul_KkogjiDalrinIeung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Mieum")]
	public const int Hangul_Mieum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_MultipleCandidate")]
	public const int Hangul_MultipleCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Nieun")]
	public const int Hangul_Nieun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_NieunHieuh")]
	public const int Hangul_NieunHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_NieunJieuj")]
	public const int Hangul_NieunJieuj;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_O")]
	public const int Hangul_O;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_OE")]
	public const int Hangul_OE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_PanSios")]
	public const int Hangul_PanSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Phieuf")]
	public const int Hangul_Phieuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Pieub")]
	public const int Hangul_Pieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_PieubSios")]
	public const int Hangul_PieubSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_PostHanja")]
	public const int Hangul_PostHanja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_PreHanja")]
	public const int Hangul_PreHanja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_PreviousCandidate")]
	public const int Hangul_PreviousCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Rieul")]
	public const int Hangul_Rieul;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulHieuh")]
	public const int Hangul_RieulHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulKiyeog")]
	public const int Hangul_RieulKiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulMieum")]
	public const int Hangul_RieulMieum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulPhieuf")]
	public const int Hangul_RieulPhieuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulPieub")]
	public const int Hangul_RieulPieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulSios")]
	public const int Hangul_RieulSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulTieut")]
	public const int Hangul_RieulTieut;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_RieulYeorinHieuh")]
	public const int Hangul_RieulYeorinHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Romaja")]
	public const int Hangul_Romaja;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SingleCandidate")]
	public const int Hangul_SingleCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Sios")]
	public const int Hangul_Sios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Special")]
	public const int Hangul_Special;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SsangDikeud")]
	public const int Hangul_SsangDikeud;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SsangJieuj")]
	public const int Hangul_SsangJieuj;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SsangKiyeog")]
	public const int Hangul_SsangKiyeog;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SsangPieub")]
	public const int Hangul_SsangPieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SsangSios")]
	public const int Hangul_SsangSios;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Start")]
	public const int Hangul_Start;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SunkyeongeumMieum")]
	public const int Hangul_SunkyeongeumMieum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SunkyeongeumPhieuf")]
	public const int Hangul_SunkyeongeumPhieuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_SunkyeongeumPieub")]
	public const int Hangul_SunkyeongeumPieub;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_Tieut")]
	public const int Hangul_Tieut;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_U")]
	public const int Hangul_U;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_WA")]
	public const int Hangul_WA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_WAE")]
	public const int Hangul_WAE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_WE")]
	public const int Hangul_WE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_WEO")]
	public const int Hangul_WEO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_WI")]
	public const int Hangul_WI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YA")]
	public const int Hangul_YA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YAE")]
	public const int Hangul_YAE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YE")]
	public const int Hangul_YE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YEO")]
	public const int Hangul_YEO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YI")]
	public const int Hangul_YI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YO")]
	public const int Hangul_YO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YU")]
	public const int Hangul_YU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_YeorinHieuh")]
	public const int Hangul_YeorinHieuh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hangul_switch")]
	public const int Hangul_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hankaku")]
	public const int Hankaku;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hcircumflex")]
	public const int Hcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hebrew_switch")]
	public const int Hebrew_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Help")]
	public const int Help;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Henkan")]
	public const int Henkan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Henkan_Mode")]
	public const int Henkan_Mode;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hiragana")]
	public const int Hiragana;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hiragana_Katakana")]
	public const int Hiragana_Katakana;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Home")]
	public const int Home;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hstroke")]
	public const int Hstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hyper_L")]
	public const int Hyper_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Hyper_R")]
	public const int Hyper_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_I")]
	public const int I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_CONFIG")]
	public const string INTERFACE_CONFIG;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_ENGINE")]
	public const string INTERFACE_ENGINE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_FACTORY")]
	public const string INTERFACE_FACTORY;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_IBUS")]
	public const string INTERFACE_IBUS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_INPUT_CONTEXT")]
	public const string INTERFACE_INPUT_CONTEXT;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_NOTIFICATIONS")]
	public const string INTERFACE_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_INTERFACE_PANEL")]
	public const string INTERFACE_PANEL;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Center_Object")]
	public const int ISO_Center_Object;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Continuous_Underline")]
	public const int ISO_Continuous_Underline;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Discontinuous_Underline")]
	public const int ISO_Discontinuous_Underline;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Emphasize")]
	public const int ISO_Emphasize;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Enter")]
	public const int ISO_Enter;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Fast_Cursor_Down")]
	public const int ISO_Fast_Cursor_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Fast_Cursor_Left")]
	public const int ISO_Fast_Cursor_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Fast_Cursor_Right")]
	public const int ISO_Fast_Cursor_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Fast_Cursor_Up")]
	public const int ISO_Fast_Cursor_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_First_Group")]
	public const int ISO_First_Group;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_First_Group_Lock")]
	public const int ISO_First_Group_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Group_Latch")]
	public const int ISO_Group_Latch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Group_Lock")]
	public const int ISO_Group_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Group_Shift")]
	public const int ISO_Group_Shift;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Last_Group")]
	public const int ISO_Last_Group;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Last_Group_Lock")]
	public const int ISO_Last_Group_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Left_Tab")]
	public const int ISO_Left_Tab;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level2_Latch")]
	public const int ISO_Level2_Latch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level3_Latch")]
	public const int ISO_Level3_Latch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level3_Lock")]
	public const int ISO_Level3_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level3_Shift")]
	public const int ISO_Level3_Shift;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level5_Latch")]
	public const int ISO_Level5_Latch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level5_Lock")]
	public const int ISO_Level5_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Level5_Shift")]
	public const int ISO_Level5_Shift;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Lock")]
	public const int ISO_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Move_Line_Down")]
	public const int ISO_Move_Line_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Move_Line_Up")]
	public const int ISO_Move_Line_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Next_Group")]
	public const int ISO_Next_Group;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Next_Group_Lock")]
	public const int ISO_Next_Group_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Partial_Line_Down")]
	public const int ISO_Partial_Line_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Partial_Line_Up")]
	public const int ISO_Partial_Line_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Partial_Space_Left")]
	public const int ISO_Partial_Space_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Partial_Space_Right")]
	public const int ISO_Partial_Space_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Prev_Group")]
	public const int ISO_Prev_Group;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Prev_Group_Lock")]
	public const int ISO_Prev_Group_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Release_Both_Margins")]
	public const int ISO_Release_Both_Margins;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Release_Margin_Left")]
	public const int ISO_Release_Margin_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Release_Margin_Right")]
	public const int ISO_Release_Margin_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Set_Margin_Left")]
	public const int ISO_Set_Margin_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ISO_Set_Margin_Right")]
	public const int ISO_Set_Margin_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Iabovedot")]
	public const int Iabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Iacute")]
	public const int Iacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ibelowdot")]
	public const int Ibelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ibreve")]
	public const int Ibreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Icircumflex")]
	public const int Icircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Idiaeresis")]
	public const int Idiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Igrave")]
	public const int Igrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ihook")]
	public const int Ihook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Imacron")]
	public const int Imacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Insert")]
	public const int Insert;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Iogonek")]
	public const int Iogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Itilde")]
	public const int Itilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_J")]
	public const int J;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Jcircumflex")]
	public const int Jcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_K")]
	public const int K;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_0")]
	public const int KP_0;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_1")]
	public const int KP_1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_2")]
	public const int KP_2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_3")]
	public const int KP_3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_4")]
	public const int KP_4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_5")]
	public const int KP_5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_6")]
	public const int KP_6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_7")]
	public const int KP_7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_8")]
	public const int KP_8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_9")]
	public const int KP_9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Add")]
	public const int KP_Add;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Begin")]
	public const int KP_Begin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Decimal")]
	public const int KP_Decimal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Delete")]
	public const int KP_Delete;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Divide")]
	public const int KP_Divide;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Down")]
	public const int KP_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_End")]
	public const int KP_End;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Enter")]
	public const int KP_Enter;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Equal")]
	public const int KP_Equal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_F1")]
	public const int KP_F1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_F2")]
	public const int KP_F2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_F3")]
	public const int KP_F3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_F4")]
	public const int KP_F4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Home")]
	public const int KP_Home;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Insert")]
	public const int KP_Insert;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Left")]
	public const int KP_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Multiply")]
	public const int KP_Multiply;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Next")]
	public const int KP_Next;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Page_Down")]
	public const int KP_Page_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Page_Up")]
	public const int KP_Page_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Prior")]
	public const int KP_Prior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Right")]
	public const int KP_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Separator")]
	public const int KP_Separator;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Space")]
	public const int KP_Space;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Subtract")]
	public const int KP_Subtract;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Tab")]
	public const int KP_Tab;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_KP_Up")]
	public const int KP_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Kana_Lock")]
	public const int Kana_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Kana_Shift")]
	public const int Kana_Shift;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Kanji")]
	public const int Kanji;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Kanji_Bangou")]
	public const int Kanji_Bangou;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Katakana")]
	public const int Katakana;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Kcedilla")]
	public const int Kcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Korean_Won")]
	public const int Korean_Won;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L")]
	public const int L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L1")]
	public const int L1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L10")]
	public const int L10;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L2")]
	public const int L2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L3")]
	public const int L3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L4")]
	public const int L4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L5")]
	public const int L5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L6")]
	public const int L6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L7")]
	public const int L7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L8")]
	public const int L8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_L9")]
	public const int L9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Lacute")]
	public const int Lacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Last_Virtual_Screen")]
	public const int Last_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Lbelowdot")]
	public const int Lbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Lcaron")]
	public const int Lcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Lcedilla")]
	public const int Lcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Left")]
	public const int Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Linefeed")]
	public const int Linefeed;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_LiraSign")]
	public const int LiraSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Lstroke")]
	public const int Lstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_M")]
	public const int M;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Mabovedot")]
	public const int Mabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_DSE")]
	public const int Macedonia_DSE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_GJE")]
	public const int Macedonia_GJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_KJE")]
	public const int Macedonia_KJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_dse")]
	public const int Macedonia_dse;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_gje")]
	public const int Macedonia_gje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Macedonia_kje")]
	public const int Macedonia_kje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Mae_Koho")]
	public const int Mae_Koho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Massyo")]
	public const int Massyo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Menu")]
	public const int Menu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Meta_L")]
	public const int Meta_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Meta_R")]
	public const int Meta_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MillSign")]
	public const int MillSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Mode_switch")]
	public const int Mode_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MouseKeys_Accel_Enable")]
	public const int MouseKeys_Accel_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MouseKeys_Enable")]
	public const int MouseKeys_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Muhenkan")]
	public const int Muhenkan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Multi_key")]
	public const int Multi_key;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_MultipleCandidate")]
	public const int MultipleCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_N")]
	public const int N;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Nacute")]
	public const int Nacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_NairaSign")]
	public const int NairaSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ncaron")]
	public const int Ncaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ncedilla")]
	public const int Ncedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_NewSheqelSign")]
	public const int NewSheqelSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Next")]
	public const int Next;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Next_Virtual_Screen")]
	public const int Next_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ntilde")]
	public const int Ntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Num_Lock")]
	public const int Num_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_O")]
	public const int O;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_OE")]
	public const int OE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Oacute")]
	public const int Oacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Obarred")]
	public const int Obarred;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Obelowdot")]
	public const int Obelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocaron")]
	public const int Ocaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflex")]
	public const int Ocircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflexacute")]
	public const int Ocircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflexbelowdot")]
	public const int Ocircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflexgrave")]
	public const int Ocircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflexhook")]
	public const int Ocircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ocircumflextilde")]
	public const int Ocircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Odiaeresis")]
	public const int Odiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Odoubleacute")]
	public const int Odoubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ograve")]
	public const int Ograve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohook")]
	public const int Ohook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohorn")]
	public const int Ohorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohornacute")]
	public const int Ohornacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohornbelowdot")]
	public const int Ohornbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohorngrave")]
	public const int Ohorngrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohornhook")]
	public const int Ohornhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ohorntilde")]
	public const int Ohorntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Omacron")]
	public const int Omacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ooblique")]
	public const int Ooblique;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Oslash")]
	public const int Oslash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Otilde")]
	public const int Otilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Overlay1_Enable")]
	public const int Overlay1_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Overlay2_Enable")]
	public const int Overlay2_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_P")]
	public const int P;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_CONFIG")]
	public const string PATH_CONFIG;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_FACTORY")]
	public const string PATH_FACTORY;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_IBUS")]
	public const string PATH_IBUS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_INPUT_CONTEXT")]
	public const string PATH_INPUT_CONTEXT;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_NOTIFICATIONS")]
	public const string PATH_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PATH_PANEL")]
	public const string PATH_PANEL;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pabovedot")]
	public const int Pabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Page_Down")]
	public const int Page_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Page_Up")]
	public const int Page_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pause")]
	public const int Pause;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PesetaSign")]
	public const int PesetaSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Accelerate")]
	public const int Pointer_Accelerate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button1")]
	public const int Pointer_Button1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button2")]
	public const int Pointer_Button2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button3")]
	public const int Pointer_Button3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button4")]
	public const int Pointer_Button4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button5")]
	public const int Pointer_Button5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Button_Dflt")]
	public const int Pointer_Button_Dflt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick1")]
	public const int Pointer_DblClick1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick2")]
	public const int Pointer_DblClick2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick3")]
	public const int Pointer_DblClick3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick4")]
	public const int Pointer_DblClick4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick5")]
	public const int Pointer_DblClick5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DblClick_Dflt")]
	public const int Pointer_DblClick_Dflt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DfltBtnNext")]
	public const int Pointer_DfltBtnNext;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DfltBtnPrev")]
	public const int Pointer_DfltBtnPrev;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Down")]
	public const int Pointer_Down;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DownLeft")]
	public const int Pointer_DownLeft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_DownRight")]
	public const int Pointer_DownRight;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag1")]
	public const int Pointer_Drag1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag2")]
	public const int Pointer_Drag2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag3")]
	public const int Pointer_Drag3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag4")]
	public const int Pointer_Drag4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag5")]
	public const int Pointer_Drag5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Drag_Dflt")]
	public const int Pointer_Drag_Dflt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_EnableKeys")]
	public const int Pointer_EnableKeys;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Left")]
	public const int Pointer_Left;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Right")]
	public const int Pointer_Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_Up")]
	public const int Pointer_Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_UpLeft")]
	public const int Pointer_UpLeft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Pointer_UpRight")]
	public const int Pointer_UpRight;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Prev_Virtual_Screen")]
	public const int Prev_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_PreviousCandidate")]
	public const int PreviousCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Print")]
	public const int Print;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Prior")]
	public const int Prior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Q")]
	public const int Q;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R")]
	public const int R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R1")]
	public const int R1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R10")]
	public const int R10;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R11")]
	public const int R11;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R12")]
	public const int R12;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R13")]
	public const int R13;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R14")]
	public const int R14;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R15")]
	public const int R15;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R2")]
	public const int R2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R3")]
	public const int R3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R4")]
	public const int R4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R5")]
	public const int R5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R6")]
	public const int R6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R7")]
	public const int R7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R8")]
	public const int R8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_R9")]
	public const int R9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Racute")]
	public const int Racute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Rcaron")]
	public const int Rcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Rcedilla")]
	public const int Rcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Redo")]
	public const int Redo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_RepeatKeys_Enable")]
	public const int RepeatKeys_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Return")]
	public const int Return;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Right")]
	public const int Right;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Romaji")]
	public const int Romaji;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_RupeeSign")]
	public const int RupeeSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_S")]
	public const int S;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SCHWA")]
	public const int SCHWA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SERVICE_CONFIG")]
	public const string SERVICE_CONFIG;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SERVICE_IBUS")]
	public const string SERVICE_IBUS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SERVICE_NOTIFICATIONS")]
	public const string SERVICE_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SERVICE_PANEL")]
	public const string SERVICE_PANEL;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Sabovedot")]
	public const int Sabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Sacute")]
	public const int Sacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Scaron")]
	public const int Scaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Scedilla")]
	public const int Scedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Scircumflex")]
	public const int Scircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Scroll_Lock")]
	public const int Scroll_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Select")]
	public const int Select;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_DJE")]
	public const int Serbian_DJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_DZE")]
	public const int Serbian_DZE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_JE")]
	public const int Serbian_JE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_LJE")]
	public const int Serbian_LJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_NJE")]
	public const int Serbian_NJE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_TSHE")]
	public const int Serbian_TSHE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_dje")]
	public const int Serbian_dje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_dze")]
	public const int Serbian_dze;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_je")]
	public const int Serbian_je;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_lje")]
	public const int Serbian_lje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_nje")]
	public const int Serbian_nje;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Serbian_tshe")]
	public const int Serbian_tshe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Shift_L")]
	public const int Shift_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Shift_Lock")]
	public const int Shift_Lock;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Shift_R")]
	public const int Shift_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SingleCandidate")]
	public const int SingleCandidate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_SlowKeys_Enable")]
	public const int SlowKeys_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_StickyKeys_Enable")]
	public const int StickyKeys_Enable;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Super_L")]
	public const int Super_L;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Super_R")]
	public const int Super_R;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Sys_Req")]
	public const int Sys_Req;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_T")]
	public const int T;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_THORN")]
	public const int THORN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Tab")]
	public const int Tab;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Tabovedot")]
	public const int Tabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Tcaron")]
	public const int Tcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Tcedilla")]
	public const int Tcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Terminate_Server")]
	public const int Terminate_Server;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_baht")]
	public const int Thai_baht;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_bobaimai")]
	public const int Thai_bobaimai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_chochan")]
	public const int Thai_chochan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_chochang")]
	public const int Thai_chochang;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_choching")]
	public const int Thai_choching;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_chochoe")]
	public const int Thai_chochoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_dochada")]
	public const int Thai_dochada;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_dodek")]
	public const int Thai_dodek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_fofa")]
	public const int Thai_fofa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_fofan")]
	public const int Thai_fofan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_hohip")]
	public const int Thai_hohip;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_honokhuk")]
	public const int Thai_honokhuk;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_khokhai")]
	public const int Thai_khokhai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_khokhon")]
	public const int Thai_khokhon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_khokhuat")]
	public const int Thai_khokhuat;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_khokhwai")]
	public const int Thai_khokhwai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_khorakhang")]
	public const int Thai_khorakhang;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_kokai")]
	public const int Thai_kokai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lakkhangyao")]
	public const int Thai_lakkhangyao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lekchet")]
	public const int Thai_lekchet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lekha")]
	public const int Thai_lekha;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lekhok")]
	public const int Thai_lekhok;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lekkao")]
	public const int Thai_lekkao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_leknung")]
	public const int Thai_leknung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lekpaet")]
	public const int Thai_lekpaet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_leksam")]
	public const int Thai_leksam;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_leksi")]
	public const int Thai_leksi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_leksong")]
	public const int Thai_leksong;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_leksun")]
	public const int Thai_leksun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lochula")]
	public const int Thai_lochula;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_loling")]
	public const int Thai_loling;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_lu")]
	public const int Thai_lu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maichattawa")]
	public const int Thai_maichattawa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maiek")]
	public const int Thai_maiek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maihanakat")]
	public const int Thai_maihanakat;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maihanakat_maitho")]
	public const int Thai_maihanakat_maitho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maitaikhu")]
	public const int Thai_maitaikhu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maitho")]
	public const int Thai_maitho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maitri")]
	public const int Thai_maitri;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_maiyamok")]
	public const int Thai_maiyamok;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_moma")]
	public const int Thai_moma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_ngongu")]
	public const int Thai_ngongu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_nikhahit")]
	public const int Thai_nikhahit;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_nonen")]
	public const int Thai_nonen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_nonu")]
	public const int Thai_nonu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_oang")]
	public const int Thai_oang;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_paiyannoi")]
	public const int Thai_paiyannoi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_phinthu")]
	public const int Thai_phinthu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_phophan")]
	public const int Thai_phophan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_phophung")]
	public const int Thai_phophung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_phosamphao")]
	public const int Thai_phosamphao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_popla")]
	public const int Thai_popla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_rorua")]
	public const int Thai_rorua;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_ru")]
	public const int Thai_ru;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraa")]
	public const int Thai_saraa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraaa")]
	public const int Thai_saraaa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraae")]
	public const int Thai_saraae;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraaimaimalai")]
	public const int Thai_saraaimaimalai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraaimaimuan")]
	public const int Thai_saraaimaimuan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraam")]
	public const int Thai_saraam;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarae")]
	public const int Thai_sarae;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarai")]
	public const int Thai_sarai;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraii")]
	public const int Thai_saraii;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarao")]
	public const int Thai_sarao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarau")]
	public const int Thai_sarau;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_saraue")]
	public const int Thai_saraue;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarauee")]
	public const int Thai_sarauee;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sarauu")]
	public const int Thai_sarauu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sorusi")]
	public const int Thai_sorusi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sosala")]
	public const int Thai_sosala;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_soso")]
	public const int Thai_soso;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_sosua")]
	public const int Thai_sosua;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thanthakhat")]
	public const int Thai_thanthakhat;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thonangmontho")]
	public const int Thai_thonangmontho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thophuthao")]
	public const int Thai_thophuthao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thothahan")]
	public const int Thai_thothahan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thothan")]
	public const int Thai_thothan;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thothong")]
	public const int Thai_thothong;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_thothung")]
	public const int Thai_thothung;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_topatak")]
	public const int Thai_topatak;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_totao")]
	public const int Thai_totao;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_wowaen")]
	public const int Thai_wowaen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_yoyak")]
	public const int Thai_yoyak;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thai_yoying")]
	public const int Thai_yoying;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Thorn")]
	public const int Thorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Touroku")]
	public const int Touroku;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Tslash")]
	public const int Tslash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_U")]
	public const int U;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uacute")]
	public const int Uacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ubelowdot")]
	public const int Ubelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ubreve")]
	public const int Ubreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ucircumflex")]
	public const int Ucircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Udiaeresis")]
	public const int Udiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Udoubleacute")]
	public const int Udoubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ugrave")]
	public const int Ugrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhook")]
	public const int Uhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhorn")]
	public const int Uhorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhornacute")]
	public const int Uhornacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhornbelowdot")]
	public const int Uhornbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhorngrave")]
	public const int Uhorngrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhornhook")]
	public const int Uhornhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uhorntilde")]
	public const int Uhorntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_GHE_WITH_UPTURN")]
	public const int Ukrainian_GHE_WITH_UPTURN;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_I")]
	public const int Ukrainian_I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_IE")]
	public const int Ukrainian_IE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_YI")]
	public const int Ukrainian_YI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_ghe_with_upturn")]
	public const int Ukrainian_ghe_with_upturn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_i")]
	public const int Ukrainian_i;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_ie")]
	public const int Ukrainian_ie;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukrainian_yi")]
	public const int Ukrainian_yi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_I")]
	public const int Ukranian_I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_JE")]
	public const int Ukranian_JE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_YI")]
	public const int Ukranian_YI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_i")]
	public const int Ukranian_i;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_je")]
	public const int Ukranian_je;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ukranian_yi")]
	public const int Ukranian_yi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Umacron")]
	public const int Umacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Undo")]
	public const int Undo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uogonek")]
	public const int Uogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Up")]
	public const int Up;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Uring")]
	public const int Uring;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Utilde")]
	public const int Utilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_V")]
	public const int V;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_VoidSymbol")]
	public const int VoidSymbol;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_W")]
	public const int W;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Wacute")]
	public const int Wacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Wcircumflex")]
	public const int Wcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Wdiaeresis")]
	public const int Wdiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Wgrave")]
	public const int Wgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_WonSign")]
	public const int WonSign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_X")]
	public const int X;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Xabovedot")]
	public const int Xabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Y")]
	public const int Y;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Yacute")]
	public const int Yacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ybelowdot")]
	public const int Ybelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ycircumflex")]
	public const int Ycircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ydiaeresis")]
	public const int Ydiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ygrave")]
	public const int Ygrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Yhook")]
	public const int Yhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Ytilde")]
	public const int Ytilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Z")]
	public const int Z;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zabovedot")]
	public const int Zabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zacute")]
	public const int Zacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zcaron")]
	public const int Zcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zen_Koho")]
	public const int Zen_Koho;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zenkaku")]
	public const int Zenkaku;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zenkaku_Hankaku")]
	public const int Zenkaku_Hankaku;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_Zstroke")]
	public const int Zstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_a")]
	public const int a;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_aacute")]
	public const int aacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abelowdot")]
	public const int abelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abovedot")]
	public const int abovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abreve")]
	public const int abreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abreveacute")]
	public const int abreveacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abrevebelowdot")]
	public const int abrevebelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abrevegrave")]
	public const int abrevegrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abrevehook")]
	public const int abrevehook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_abrevetilde")]
	public const int abrevetilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflex")]
	public const int acircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflexacute")]
	public const int acircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflexbelowdot")]
	public const int acircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflexgrave")]
	public const int acircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflexhook")]
	public const int acircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acircumflextilde")]
	public const int acircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_acute")]
	public const int acute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_adiaeresis")]
	public const int adiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ae")]
	public const int ae;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_agrave")]
	public const int agrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ahook")]
	public const int ahook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_amacron")]
	public const int amacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ampersand")]
	public const int ampersand;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_aogonek")]
	public const int aogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_apostrophe")]
	public const int apostrophe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_approxeq")]
	public const int approxeq;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_approximate")]
	public const int approximate;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_aring")]
	public const int aring;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_asciicircum")]
	public const int asciicircum;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_asciitilde")]
	public const int asciitilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_asterisk")]
	public const int asterisk;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_at")]
	public const int at;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_atilde")]
	public const int atilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_b")]
	public const int b;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_babovedot")]
	public const int babovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_backslash")]
	public const int backslash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ballotcross")]
	public const int ballotcross;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_bar")]
	public const int bar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_because")]
	public const int because;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_blank")]
	public const int blank;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botintegral")]
	public const int botintegral;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botleftparens")]
	public const int botleftparens;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botleftsqbracket")]
	public const int botleftsqbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botleftsummation")]
	public const int botleftsummation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botrightparens")]
	public const int botrightparens;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botrightsqbracket")]
	public const int botrightsqbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botrightsummation")]
	public const int botrightsummation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_bott")]
	public const int bott;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_botvertsummationconnector")]
	public const int botvertsummationconnector;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braceleft")]
	public const int braceleft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braceright")]
	public const int braceright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_bracketleft")]
	public const int bracketleft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_bracketright")]
	public const int bracketright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_blank")]
	public const int braille_blank;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_1")]
	public const int braille_dot_1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_10")]
	public const int braille_dot_10;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_2")]
	public const int braille_dot_2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_3")]
	public const int braille_dot_3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_4")]
	public const int braille_dot_4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_5")]
	public const int braille_dot_5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_6")]
	public const int braille_dot_6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_7")]
	public const int braille_dot_7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_8")]
	public const int braille_dot_8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dot_9")]
	public const int braille_dot_9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1")]
	public const int braille_dots_1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12")]
	public const int braille_dots_12;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123")]
	public const int braille_dots_123;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1234")]
	public const int braille_dots_1234;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12345")]
	public const int braille_dots_12345;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123456")]
	public const int braille_dots_123456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1234567")]
	public const int braille_dots_1234567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12345678")]
	public const int braille_dots_12345678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1234568")]
	public const int braille_dots_1234568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123457")]
	public const int braille_dots_123457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1234578")]
	public const int braille_dots_1234578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123458")]
	public const int braille_dots_123458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12346")]
	public const int braille_dots_12346;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123467")]
	public const int braille_dots_123467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1234678")]
	public const int braille_dots_1234678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123468")]
	public const int braille_dots_123468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12347")]
	public const int braille_dots_12347;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123478")]
	public const int braille_dots_123478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12348")]
	public const int braille_dots_12348;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1235")]
	public const int braille_dots_1235;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12356")]
	public const int braille_dots_12356;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123567")]
	public const int braille_dots_123567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1235678")]
	public const int braille_dots_1235678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123568")]
	public const int braille_dots_123568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12357")]
	public const int braille_dots_12357;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123578")]
	public const int braille_dots_123578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12358")]
	public const int braille_dots_12358;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1236")]
	public const int braille_dots_1236;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12367")]
	public const int braille_dots_12367;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_123678")]
	public const int braille_dots_123678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12368")]
	public const int braille_dots_12368;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1237")]
	public const int braille_dots_1237;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12378")]
	public const int braille_dots_12378;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1238")]
	public const int braille_dots_1238;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_124")]
	public const int braille_dots_124;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1245")]
	public const int braille_dots_1245;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12456")]
	public const int braille_dots_12456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_124567")]
	public const int braille_dots_124567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1245678")]
	public const int braille_dots_1245678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_124568")]
	public const int braille_dots_124568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12457")]
	public const int braille_dots_12457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_124578")]
	public const int braille_dots_124578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12458")]
	public const int braille_dots_12458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1246")]
	public const int braille_dots_1246;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12467")]
	public const int braille_dots_12467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_124678")]
	public const int braille_dots_124678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12468")]
	public const int braille_dots_12468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1247")]
	public const int braille_dots_1247;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12478")]
	public const int braille_dots_12478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1248")]
	public const int braille_dots_1248;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_125")]
	public const int braille_dots_125;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1256")]
	public const int braille_dots_1256;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12567")]
	public const int braille_dots_12567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_125678")]
	public const int braille_dots_125678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12568")]
	public const int braille_dots_12568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1257")]
	public const int braille_dots_1257;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12578")]
	public const int braille_dots_12578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1258")]
	public const int braille_dots_1258;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_126")]
	public const int braille_dots_126;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1267")]
	public const int braille_dots_1267;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_12678")]
	public const int braille_dots_12678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1268")]
	public const int braille_dots_1268;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_127")]
	public const int braille_dots_127;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1278")]
	public const int braille_dots_1278;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_128")]
	public const int braille_dots_128;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13")]
	public const int braille_dots_13;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_134")]
	public const int braille_dots_134;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1345")]
	public const int braille_dots_1345;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13456")]
	public const int braille_dots_13456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_134567")]
	public const int braille_dots_134567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1345678")]
	public const int braille_dots_1345678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_134568")]
	public const int braille_dots_134568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13457")]
	public const int braille_dots_13457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_134578")]
	public const int braille_dots_134578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13458")]
	public const int braille_dots_13458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1346")]
	public const int braille_dots_1346;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13467")]
	public const int braille_dots_13467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_134678")]
	public const int braille_dots_134678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13468")]
	public const int braille_dots_13468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1347")]
	public const int braille_dots_1347;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13478")]
	public const int braille_dots_13478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1348")]
	public const int braille_dots_1348;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_135")]
	public const int braille_dots_135;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1356")]
	public const int braille_dots_1356;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13567")]
	public const int braille_dots_13567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_135678")]
	public const int braille_dots_135678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13568")]
	public const int braille_dots_13568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1357")]
	public const int braille_dots_1357;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13578")]
	public const int braille_dots_13578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1358")]
	public const int braille_dots_1358;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_136")]
	public const int braille_dots_136;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1367")]
	public const int braille_dots_1367;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_13678")]
	public const int braille_dots_13678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1368")]
	public const int braille_dots_1368;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_137")]
	public const int braille_dots_137;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1378")]
	public const int braille_dots_1378;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_138")]
	public const int braille_dots_138;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_14")]
	public const int braille_dots_14;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_145")]
	public const int braille_dots_145;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1456")]
	public const int braille_dots_1456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_14567")]
	public const int braille_dots_14567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_145678")]
	public const int braille_dots_145678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_14568")]
	public const int braille_dots_14568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1457")]
	public const int braille_dots_1457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_14578")]
	public const int braille_dots_14578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1458")]
	public const int braille_dots_1458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_146")]
	public const int braille_dots_146;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1467")]
	public const int braille_dots_1467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_14678")]
	public const int braille_dots_14678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1468")]
	public const int braille_dots_1468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_147")]
	public const int braille_dots_147;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1478")]
	public const int braille_dots_1478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_148")]
	public const int braille_dots_148;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_15")]
	public const int braille_dots_15;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_156")]
	public const int braille_dots_156;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1567")]
	public const int braille_dots_1567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_15678")]
	public const int braille_dots_15678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1568")]
	public const int braille_dots_1568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_157")]
	public const int braille_dots_157;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1578")]
	public const int braille_dots_1578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_158")]
	public const int braille_dots_158;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_16")]
	public const int braille_dots_16;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_167")]
	public const int braille_dots_167;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_1678")]
	public const int braille_dots_1678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_168")]
	public const int braille_dots_168;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_17")]
	public const int braille_dots_17;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_178")]
	public const int braille_dots_178;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_18")]
	public const int braille_dots_18;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2")]
	public const int braille_dots_2;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23")]
	public const int braille_dots_23;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_234")]
	public const int braille_dots_234;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2345")]
	public const int braille_dots_2345;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23456")]
	public const int braille_dots_23456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_234567")]
	public const int braille_dots_234567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2345678")]
	public const int braille_dots_2345678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_234568")]
	public const int braille_dots_234568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23457")]
	public const int braille_dots_23457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_234578")]
	public const int braille_dots_234578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23458")]
	public const int braille_dots_23458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2346")]
	public const int braille_dots_2346;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23467")]
	public const int braille_dots_23467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_234678")]
	public const int braille_dots_234678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23468")]
	public const int braille_dots_23468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2347")]
	public const int braille_dots_2347;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23478")]
	public const int braille_dots_23478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2348")]
	public const int braille_dots_2348;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_235")]
	public const int braille_dots_235;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2356")]
	public const int braille_dots_2356;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23567")]
	public const int braille_dots_23567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_235678")]
	public const int braille_dots_235678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23568")]
	public const int braille_dots_23568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2357")]
	public const int braille_dots_2357;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23578")]
	public const int braille_dots_23578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2358")]
	public const int braille_dots_2358;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_236")]
	public const int braille_dots_236;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2367")]
	public const int braille_dots_2367;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_23678")]
	public const int braille_dots_23678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2368")]
	public const int braille_dots_2368;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_237")]
	public const int braille_dots_237;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2378")]
	public const int braille_dots_2378;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_238")]
	public const int braille_dots_238;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_24")]
	public const int braille_dots_24;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_245")]
	public const int braille_dots_245;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2456")]
	public const int braille_dots_2456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_24567")]
	public const int braille_dots_24567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_245678")]
	public const int braille_dots_245678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_24568")]
	public const int braille_dots_24568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2457")]
	public const int braille_dots_2457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_24578")]
	public const int braille_dots_24578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2458")]
	public const int braille_dots_2458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_246")]
	public const int braille_dots_246;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2467")]
	public const int braille_dots_2467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_24678")]
	public const int braille_dots_24678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2468")]
	public const int braille_dots_2468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_247")]
	public const int braille_dots_247;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2478")]
	public const int braille_dots_2478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_248")]
	public const int braille_dots_248;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_25")]
	public const int braille_dots_25;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_256")]
	public const int braille_dots_256;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2567")]
	public const int braille_dots_2567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_25678")]
	public const int braille_dots_25678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2568")]
	public const int braille_dots_2568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_257")]
	public const int braille_dots_257;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2578")]
	public const int braille_dots_2578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_258")]
	public const int braille_dots_258;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_26")]
	public const int braille_dots_26;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_267")]
	public const int braille_dots_267;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_2678")]
	public const int braille_dots_2678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_268")]
	public const int braille_dots_268;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_27")]
	public const int braille_dots_27;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_278")]
	public const int braille_dots_278;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_28")]
	public const int braille_dots_28;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3")]
	public const int braille_dots_3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_34")]
	public const int braille_dots_34;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_345")]
	public const int braille_dots_345;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3456")]
	public const int braille_dots_3456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_34567")]
	public const int braille_dots_34567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_345678")]
	public const int braille_dots_345678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_34568")]
	public const int braille_dots_34568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3457")]
	public const int braille_dots_3457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_34578")]
	public const int braille_dots_34578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3458")]
	public const int braille_dots_3458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_346")]
	public const int braille_dots_346;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3467")]
	public const int braille_dots_3467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_34678")]
	public const int braille_dots_34678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3468")]
	public const int braille_dots_3468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_347")]
	public const int braille_dots_347;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3478")]
	public const int braille_dots_3478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_348")]
	public const int braille_dots_348;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_35")]
	public const int braille_dots_35;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_356")]
	public const int braille_dots_356;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3567")]
	public const int braille_dots_3567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_35678")]
	public const int braille_dots_35678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3568")]
	public const int braille_dots_3568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_357")]
	public const int braille_dots_357;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3578")]
	public const int braille_dots_3578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_358")]
	public const int braille_dots_358;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_36")]
	public const int braille_dots_36;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_367")]
	public const int braille_dots_367;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_3678")]
	public const int braille_dots_3678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_368")]
	public const int braille_dots_368;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_37")]
	public const int braille_dots_37;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_378")]
	public const int braille_dots_378;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_38")]
	public const int braille_dots_38;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_4")]
	public const int braille_dots_4;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_45")]
	public const int braille_dots_45;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_456")]
	public const int braille_dots_456;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_4567")]
	public const int braille_dots_4567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_45678")]
	public const int braille_dots_45678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_4568")]
	public const int braille_dots_4568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_457")]
	public const int braille_dots_457;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_4578")]
	public const int braille_dots_4578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_458")]
	public const int braille_dots_458;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_46")]
	public const int braille_dots_46;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_467")]
	public const int braille_dots_467;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_4678")]
	public const int braille_dots_4678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_468")]
	public const int braille_dots_468;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_47")]
	public const int braille_dots_47;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_478")]
	public const int braille_dots_478;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_48")]
	public const int braille_dots_48;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_5")]
	public const int braille_dots_5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_56")]
	public const int braille_dots_56;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_567")]
	public const int braille_dots_567;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_5678")]
	public const int braille_dots_5678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_568")]
	public const int braille_dots_568;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_57")]
	public const int braille_dots_57;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_578")]
	public const int braille_dots_578;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_58")]
	public const int braille_dots_58;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_6")]
	public const int braille_dots_6;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_67")]
	public const int braille_dots_67;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_678")]
	public const int braille_dots_678;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_68")]
	public const int braille_dots_68;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_7")]
	public const int braille_dots_7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_78")]
	public const int braille_dots_78;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_braille_dots_8")]
	public const int braille_dots_8;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_breve")]
	public const int breve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_brokenbar")]
	public const int brokenbar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_c")]
	public const int c;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cabovedot")]
	public const int cabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cacute")]
	public const int cacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_careof")]
	public const int careof;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_caret")]
	public const int caret;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_caron")]
	public const int caron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ccaron")]
	public const int ccaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ccedilla")]
	public const int ccedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ccircumflex")]
	public const int ccircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cedilla")]
	public const int cedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cent")]
	public const int cent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_checkerboard")]
	public const int checkerboard;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_checkmark")]
	public const int checkmark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_circle")]
	public const int circle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_club")]
	public const int club;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_colon")]
	public const int colon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_comma")]
	public const int comma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_containsas")]
	public const int containsas;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_copyright")]
	public const int copyright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cr")]
	public const int cr;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_crossinglines")]
	public const int crossinglines;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cuberoot")]
	public const int cuberoot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_currency")]
	public const int currency;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_cursor")]
	public const int cursor;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_d")]
	public const int d;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dabovedot")]
	public const int dabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dagger")]
	public const int dagger;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dcaron")]
	public const int dcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_abovecomma")]
	public const int dead_abovecomma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_abovedot")]
	public const int dead_abovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_abovereversedcomma")]
	public const int dead_abovereversedcomma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_abovering")]
	public const int dead_abovering;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_acute")]
	public const int dead_acute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowbreve")]
	public const int dead_belowbreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowcircumflex")]
	public const int dead_belowcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowdiaeresis")]
	public const int dead_belowdiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowdot")]
	public const int dead_belowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowmacron")]
	public const int dead_belowmacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowring")]
	public const int dead_belowring;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_belowtilde")]
	public const int dead_belowtilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_breve")]
	public const int dead_breve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_caron")]
	public const int dead_caron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_cedilla")]
	public const int dead_cedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_circumflex")]
	public const int dead_circumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_dasia")]
	public const int dead_dasia;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_diaeresis")]
	public const int dead_diaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_doubleacute")]
	public const int dead_doubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_grave")]
	public const int dead_grave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_hook")]
	public const int dead_hook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_horn")]
	public const int dead_horn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_iota")]
	public const int dead_iota;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_macron")]
	public const int dead_macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_ogonek")]
	public const int dead_ogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_perispomeni")]
	public const int dead_perispomeni;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_psili")]
	public const int dead_psili;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_semivoiced_sound")]
	public const int dead_semivoiced_sound;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_stroke")]
	public const int dead_stroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_tilde")]
	public const int dead_tilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dead_voiced_sound")]
	public const int dead_voiced_sound;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_decimalpoint")]
	public const int decimalpoint;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_degree")]
	public const int degree;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_diaeresis")]
	public const int diaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_diamond")]
	public const int diamond;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_digitspace")]
	public const int digitspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dintegral")]
	public const int dintegral;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_division")]
	public const int division;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dollar")]
	public const int dollar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_doubbaselinedot")]
	public const int doubbaselinedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_doubleacute")]
	public const int doubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_doubledagger")]
	public const int doubledagger;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_doublelowquotemark")]
	public const int doublelowquotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_downarrow")]
	public const int downarrow;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_downcaret")]
	public const int downcaret;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_downshoe")]
	public const int downshoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_downstile")]
	public const int downstile;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_downtack")]
	public const int downtack;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_dstroke")]
	public const int dstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_e")]
	public const int e;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eabovedot")]
	public const int eabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eacute")]
	public const int eacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ebelowdot")]
	public const int ebelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecaron")]
	public const int ecaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflex")]
	public const int ecircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflexacute")]
	public const int ecircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflexbelowdot")]
	public const int ecircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflexgrave")]
	public const int ecircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflexhook")]
	public const int ecircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ecircumflextilde")]
	public const int ecircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ediaeresis")]
	public const int ediaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_egrave")]
	public const int egrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ehook")]
	public const int ehook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eightsubscript")]
	public const int eightsubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eightsuperior")]
	public const int eightsuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_elementof")]
	public const int elementof;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ellipsis")]
	public const int ellipsis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_em3space")]
	public const int em3space;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_em4space")]
	public const int em4space;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emacron")]
	public const int emacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emdash")]
	public const int emdash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emfilledcircle")]
	public const int emfilledcircle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emfilledrect")]
	public const int emfilledrect;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emopencircle")]
	public const int emopencircle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emopenrectangle")]
	public const int emopenrectangle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emptyset")]
	public const int emptyset;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_emspace")]
	public const int emspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_endash")]
	public const int endash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_enfilledcircbullet")]
	public const int enfilledcircbullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_enfilledsqbullet")]
	public const int enfilledsqbullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eng")]
	public const int eng;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_enopencircbullet")]
	public const int enopencircbullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_enopensquarebullet")]
	public const int enopensquarebullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_enspace")]
	public const int enspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eogonek")]
	public const int eogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_equal")]
	public const int equal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_eth")]
	public const int eth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_etilde")]
	public const int etilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_exclam")]
	public const int exclam;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_exclamdown")]
	public const int exclamdown;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_f")]
	public const int f;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fabovedot")]
	public const int fabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_femalesymbol")]
	public const int femalesymbol;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ff")]
	public const int ff;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_figdash")]
	public const int figdash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_filledlefttribullet")]
	public const int filledlefttribullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_filledrectbullet")]
	public const int filledrectbullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_filledrighttribullet")]
	public const int filledrighttribullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_filledtribulletdown")]
	public const int filledtribulletdown;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_filledtribulletup")]
	public const int filledtribulletup;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fiveeighths")]
	public const int fiveeighths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fivesixths")]
	public const int fivesixths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fivesubscript")]
	public const int fivesubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fivesuperior")]
	public const int fivesuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fourfifths")]
	public const int fourfifths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_foursubscript")]
	public const int foursubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_foursuperior")]
	public const int foursuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_fourthroot")]
	public const int fourthroot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_function")]
	public const int function;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_g")]
	public const int g;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_gabovedot")]
	public const int gabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_gbreve")]
	public const int gbreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_gcaron")]
	public const int gcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_gcedilla")]
	public const int gcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_gcircumflex")]
	public const int gcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_grave")]
	public const int grave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_greater")]
	public const int greater;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_greaterthanequal")]
	public const int greaterthanequal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_guillemotleft")]
	public const int guillemotleft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_guillemotright")]
	public const int guillemotright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_h")]
	public const int h;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hairspace")]
	public const int hairspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hcircumflex")]
	public const int hcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_heart")]
	public const int heart;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_aleph")]
	public const int hebrew_aleph;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_ayin")]
	public const int hebrew_ayin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_bet")]
	public const int hebrew_bet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_beth")]
	public const int hebrew_beth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_chet")]
	public const int hebrew_chet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_dalet")]
	public const int hebrew_dalet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_daleth")]
	public const int hebrew_daleth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_doublelowline")]
	public const int hebrew_doublelowline;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalkaph")]
	public const int hebrew_finalkaph;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalmem")]
	public const int hebrew_finalmem;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalnun")]
	public const int hebrew_finalnun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalpe")]
	public const int hebrew_finalpe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalzade")]
	public const int hebrew_finalzade;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_finalzadi")]
	public const int hebrew_finalzadi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_gimel")]
	public const int hebrew_gimel;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_gimmel")]
	public const int hebrew_gimmel;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_he")]
	public const int hebrew_he;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_het")]
	public const int hebrew_het;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_kaph")]
	public const int hebrew_kaph;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_kuf")]
	public const int hebrew_kuf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_lamed")]
	public const int hebrew_lamed;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_mem")]
	public const int hebrew_mem;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_nun")]
	public const int hebrew_nun;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_pe")]
	public const int hebrew_pe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_qoph")]
	public const int hebrew_qoph;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_resh")]
	public const int hebrew_resh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_samech")]
	public const int hebrew_samech;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_samekh")]
	public const int hebrew_samekh;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_shin")]
	public const int hebrew_shin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_taf")]
	public const int hebrew_taf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_taw")]
	public const int hebrew_taw;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_tet")]
	public const int hebrew_tet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_teth")]
	public const int hebrew_teth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_waw")]
	public const int hebrew_waw;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_yod")]
	public const int hebrew_yod;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_zade")]
	public const int hebrew_zade;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_zadi")]
	public const int hebrew_zadi;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_zain")]
	public const int hebrew_zain;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hebrew_zayin")]
	public const int hebrew_zayin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hexagram")]
	public const int hexagram;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizconnector")]
	public const int horizconnector;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizlinescan1")]
	public const int horizlinescan1;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizlinescan3")]
	public const int horizlinescan3;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizlinescan5")]
	public const int horizlinescan5;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizlinescan7")]
	public const int horizlinescan7;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_horizlinescan9")]
	public const int horizlinescan9;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hstroke")]
	public const int hstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ht")]
	public const int ht;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_hyphen")]
	public const int hyphen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_i")]
	public const int i;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_iacute")]
	public const int iacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ibelowdot")]
	public const int ibelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ibreve")]
	public const int ibreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_icircumflex")]
	public const int icircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_identical")]
	public const int identical;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_idiaeresis")]
	public const int idiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_idotless")]
	public const int idotless;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ifonlyif")]
	public const int ifonlyif;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_igrave")]
	public const int igrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ihook")]
	public const int ihook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_imacron")]
	public const int imacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_implies")]
	public const int implies;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_includedin")]
	public const int includedin;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_includes")]
	public const int includes;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_infinity")]
	public const int infinity;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_integral")]
	public const int integral;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_intersection")]
	public const int intersection;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_iogonek")]
	public const int iogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_itilde")]
	public const int itilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_j")]
	public const int j;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_jcircumflex")]
	public const int jcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_jot")]
	public const int jot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_k")]
	public const int k;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_A")]
	public const int kana_A;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_CHI")]
	public const int kana_CHI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_E")]
	public const int kana_E;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_FU")]
	public const int kana_FU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_HA")]
	public const int kana_HA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_HE")]
	public const int kana_HE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_HI")]
	public const int kana_HI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_HO")]
	public const int kana_HO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_HU")]
	public const int kana_HU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_I")]
	public const int kana_I;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_KA")]
	public const int kana_KA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_KE")]
	public const int kana_KE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_KI")]
	public const int kana_KI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_KO")]
	public const int kana_KO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_KU")]
	public const int kana_KU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_MA")]
	public const int kana_MA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_ME")]
	public const int kana_ME;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_MI")]
	public const int kana_MI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_MO")]
	public const int kana_MO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_MU")]
	public const int kana_MU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_N")]
	public const int kana_N;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_NA")]
	public const int kana_NA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_NE")]
	public const int kana_NE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_NI")]
	public const int kana_NI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_NO")]
	public const int kana_NO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_NU")]
	public const int kana_NU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_O")]
	public const int kana_O;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_RA")]
	public const int kana_RA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_RE")]
	public const int kana_RE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_RI")]
	public const int kana_RI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_RO")]
	public const int kana_RO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_RU")]
	public const int kana_RU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_SA")]
	public const int kana_SA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_SE")]
	public const int kana_SE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_SHI")]
	public const int kana_SHI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_SO")]
	public const int kana_SO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_SU")]
	public const int kana_SU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TA")]
	public const int kana_TA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TE")]
	public const int kana_TE;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TI")]
	public const int kana_TI;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TO")]
	public const int kana_TO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TSU")]
	public const int kana_TSU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_TU")]
	public const int kana_TU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_U")]
	public const int kana_U;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_WA")]
	public const int kana_WA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_WO")]
	public const int kana_WO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_YA")]
	public const int kana_YA;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_YO")]
	public const int kana_YO;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_YU")]
	public const int kana_YU;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_a")]
	public const int kana_a;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_closingbracket")]
	public const int kana_closingbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_comma")]
	public const int kana_comma;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_conjunctive")]
	public const int kana_conjunctive;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_e")]
	public const int kana_e;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_fullstop")]
	public const int kana_fullstop;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_i")]
	public const int kana_i;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_middledot")]
	public const int kana_middledot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_o")]
	public const int kana_o;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_openingbracket")]
	public const int kana_openingbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_switch")]
	public const int kana_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_tsu")]
	public const int kana_tsu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_tu")]
	public const int kana_tu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_u")]
	public const int kana_u;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_ya")]
	public const int kana_ya;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_yo")]
	public const int kana_yo;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kana_yu")]
	public const int kana_yu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kappa")]
	public const int kappa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kcedilla")]
	public const int kcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_kra")]
	public const int kra;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_l")]
	public const int l;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lacute")]
	public const int lacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_latincross")]
	public const int latincross;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lbelowdot")]
	public const int lbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lcaron")]
	public const int lcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lcedilla")]
	public const int lcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftanglebracket")]
	public const int leftanglebracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftarrow")]
	public const int leftarrow;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftcaret")]
	public const int leftcaret;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftdoublequotemark")]
	public const int leftdoublequotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftmiddlecurlybrace")]
	public const int leftmiddlecurlybrace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftopentriangle")]
	public const int leftopentriangle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftpointer")]
	public const int leftpointer;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftradical")]
	public const int leftradical;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftshoe")]
	public const int leftshoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftsinglequotemark")]
	public const int leftsinglequotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_leftt")]
	public const int leftt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lefttack")]
	public const int lefttack;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_less")]
	public const int less;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lessthanequal")]
	public const int lessthanequal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lf")]
	public const int lf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_logicaland")]
	public const int logicaland;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_logicalor")]
	public const int logicalor;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lowleftcorner")]
	public const int lowleftcorner;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lowrightcorner")]
	public const int lowrightcorner;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_lstroke")]
	public const int lstroke;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_m")]
	public const int m;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_mabovedot")]
	public const int mabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_macron")]
	public const int macron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_malesymbol")]
	public const int malesymbol;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_maltesecross")]
	public const int maltesecross;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_marker")]
	public const int marker;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_masculine")]
	public const int masculine;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_minus")]
	public const int minus;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_minutes")]
	public const int minutes;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_mu")]
	public const int mu;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_multiply")]
	public const int multiply;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_musicalflat")]
	public const int musicalflat;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_musicalsharp")]
	public const int musicalsharp;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_n")]
	public const int n;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_nabla")]
	public const int nabla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_nacute")]
	public const int nacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ncaron")]
	public const int ncaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ncedilla")]
	public const int ncedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ninesubscript")]
	public const int ninesubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ninesuperior")]
	public const int ninesuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_nl")]
	public const int nl;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_nobreakspace")]
	public const int nobreakspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_notapproxeq")]
	public const int notapproxeq;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_notelementof")]
	public const int notelementof;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_notequal")]
	public const int notequal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_notidentical")]
	public const int notidentical;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_notsign")]
	public const int notsign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ntilde")]
	public const int ntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_numbersign")]
	public const int numbersign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_numerosign")]
	public const int numerosign;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_o")]
	public const int o;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_oacute")]
	public const int oacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_obarred")]
	public const int obarred;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_obelowdot")]
	public const int obelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocaron")]
	public const int ocaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflex")]
	public const int ocircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflexacute")]
	public const int ocircumflexacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflexbelowdot")]
	public const int ocircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflexgrave")]
	public const int ocircumflexgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflexhook")]
	public const int ocircumflexhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ocircumflextilde")]
	public const int ocircumflextilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_odiaeresis")]
	public const int odiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_odoubleacute")]
	public const int odoubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_oe")]
	public const int oe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ogonek")]
	public const int ogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ograve")]
	public const int ograve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohook")]
	public const int ohook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohorn")]
	public const int ohorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohornacute")]
	public const int ohornacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohornbelowdot")]
	public const int ohornbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohorngrave")]
	public const int ohorngrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohornhook")]
	public const int ohornhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ohorntilde")]
	public const int ohorntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_omacron")]
	public const int omacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_oneeighth")]
	public const int oneeighth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onefifth")]
	public const int onefifth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onehalf")]
	public const int onehalf;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onequarter")]
	public const int onequarter;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onesixth")]
	public const int onesixth;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onesubscript")]
	public const int onesubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onesuperior")]
	public const int onesuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_onethird")]
	public const int onethird;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ooblique")]
	public const int ooblique;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_openrectbullet")]
	public const int openrectbullet;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_openstar")]
	public const int openstar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_opentribulletdown")]
	public const int opentribulletdown;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_opentribulletup")]
	public const int opentribulletup;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ordfeminine")]
	public const int ordfeminine;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_oslash")]
	public const int oslash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_otilde")]
	public const int otilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_overbar")]
	public const int overbar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_overline")]
	public const int overline;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_p")]
	public const int p;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_pabovedot")]
	public const int pabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_paragraph")]
	public const int paragraph;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_parenleft")]
	public const int parenleft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_parenright")]
	public const int parenright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_partdifferential")]
	public const int partdifferential;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_partialderivative")]
	public const int partialderivative;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_percent")]
	public const int percent;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_period")]
	public const int period;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_periodcentered")]
	public const int periodcentered;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_phonographcopyright")]
	public const int phonographcopyright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_plus")]
	public const int plus;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_plusminus")]
	public const int plusminus;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_prescription")]
	public const int prescription;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_prolongedsound")]
	public const int prolongedsound;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_punctspace")]
	public const int punctspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_q")]
	public const int q;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_quad")]
	public const int quad;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_question")]
	public const int question;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_questiondown")]
	public const int questiondown;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_quotedbl")]
	public const int quotedbl;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_quoteleft")]
	public const int quoteleft;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_quoteright")]
	public const int quoteright;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_r")]
	public const int r;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_racute")]
	public const int racute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_radical")]
	public const int radical;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rcaron")]
	public const int rcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rcedilla")]
	public const int rcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_registered")]
	public const int registered;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightanglebracket")]
	public const int rightanglebracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightarrow")]
	public const int rightarrow;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightcaret")]
	public const int rightcaret;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightdoublequotemark")]
	public const int rightdoublequotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightmiddlecurlybrace")]
	public const int rightmiddlecurlybrace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightmiddlesummation")]
	public const int rightmiddlesummation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightopentriangle")]
	public const int rightopentriangle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightpointer")]
	public const int rightpointer;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightshoe")]
	public const int rightshoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightsinglequotemark")]
	public const int rightsinglequotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_rightt")]
	public const int rightt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_righttack")]
	public const int righttack;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_s")]
	public const int s;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sabovedot")]
	public const int sabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sacute")]
	public const int sacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_scaron")]
	public const int scaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_scedilla")]
	public const int scedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_schwa")]
	public const int schwa;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_scircumflex")]
	public const int scircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_script_switch")]
	public const int script_switch;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_seconds")]
	public const int seconds;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_section")]
	public const int section;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_semicolon")]
	public const int semicolon;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_semivoicedsound")]
	public const int semivoicedsound;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_seveneighths")]
	public const int seveneighths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sevensubscript")]
	public const int sevensubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sevensuperior")]
	public const int sevensuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_signaturemark")]
	public const int signaturemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_signifblank")]
	public const int signifblank;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_similarequal")]
	public const int similarequal;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_singlelowquotemark")]
	public const int singlelowquotemark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sixsubscript")]
	public const int sixsubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sixsuperior")]
	public const int sixsuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_slash")]
	public const int slash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_soliddiamond")]
	public const int soliddiamond;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_space")]
	public const int space;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_squareroot")]
	public const int squareroot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ssharp")]
	public const int ssharp;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_sterling")]
	public const int sterling;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_stricteq")]
	public const int stricteq;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_t")]
	public const int t;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_tabovedot")]
	public const int tabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_tcaron")]
	public const int tcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_tcedilla")]
	public const int tcedilla;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_telephone")]
	public const int telephone;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_telephonerecorder")]
	public const int telephonerecorder;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_therefore")]
	public const int therefore;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_thinspace")]
	public const int thinspace;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_thorn")]
	public const int thorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_threeeighths")]
	public const int threeeighths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_threefifths")]
	public const int threefifths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_threequarters")]
	public const int threequarters;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_threesubscript")]
	public const int threesubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_threesuperior")]
	public const int threesuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_tintegral")]
	public const int tintegral;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topintegral")]
	public const int topintegral;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topleftparens")]
	public const int topleftparens;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topleftradical")]
	public const int topleftradical;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topleftsqbracket")]
	public const int topleftsqbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topleftsummation")]
	public const int topleftsummation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_toprightparens")]
	public const int toprightparens;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_toprightsqbracket")]
	public const int toprightsqbracket;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_toprightsummation")]
	public const int toprightsummation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topt")]
	public const int topt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_topvertsummationconnector")]
	public const int topvertsummationconnector;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_trademark")]
	public const int trademark;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_trademarkincircle")]
	public const int trademarkincircle;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_tslash")]
	public const int tslash;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_twofifths")]
	public const int twofifths;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_twosubscript")]
	public const int twosubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_twosuperior")]
	public const int twosuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_twothirds")]
	public const int twothirds;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_u")]
	public const int u;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uacute")]
	public const int uacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ubelowdot")]
	public const int ubelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ubreve")]
	public const int ubreve;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ucircumflex")]
	public const int ucircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_udiaeresis")]
	public const int udiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_udoubleacute")]
	public const int udoubleacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ugrave")]
	public const int ugrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhook")]
	public const int uhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhorn")]
	public const int uhorn;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhornacute")]
	public const int uhornacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhornbelowdot")]
	public const int uhornbelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhorngrave")]
	public const int uhorngrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhornhook")]
	public const int uhornhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uhorntilde")]
	public const int uhorntilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_umacron")]
	public const int umacron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_underbar")]
	public const int underbar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_underscore")]
	public const int underscore;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_union")]
	public const int union;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uogonek")]
	public const int uogonek;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uparrow")]
	public const int uparrow;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_upcaret")]
	public const int upcaret;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_upleftcorner")]
	public const int upleftcorner;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uprightcorner")]
	public const int uprightcorner;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_upshoe")]
	public const int upshoe;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_upstile")]
	public const int upstile;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uptack")]
	public const int uptack;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_uring")]
	public const int uring;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_utilde")]
	public const int utilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_v")]
	public const int v;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_variation")]
	public const int variation;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_vertbar")]
	public const int vertbar;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_vertconnector")]
	public const int vertconnector;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_voicedsound")]
	public const int voicedsound;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_vt")]
	public const int vt;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_w")]
	public const int w;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_wacute")]
	public const int wacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_wcircumflex")]
	public const int wcircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_wdiaeresis")]
	public const int wdiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_wgrave")]
	public const int wgrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_x")]
	public const int x;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_xabovedot")]
	public const int xabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_y")]
	public const int y;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_yacute")]
	public const int yacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ybelowdot")]
	public const int ybelowdot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ycircumflex")]
	public const int ycircumflex;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ydiaeresis")]
	public const int ydiaeresis;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_yen")]
	public const int yen;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ygrave")]
	public const int ygrave;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_yhook")]
	public const int yhook;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_ytilde")]
	public const int ytilde;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_z")]
	public const int z;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zabovedot")]
	public const int zabovedot;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zacute")]
	public const int zacute;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zcaron")]
	public const int zcaron;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zerosubscript")]
	public const int zerosubscript;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zerosuperior")]
	public const int zerosuperior;
	[CCode (cheader_filename = "ibus.h", cname = "IBUS_zstroke")]
	public const int zstroke;
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.Attribute attr_background_new (uint color, uint start_index, uint end_index);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.Attribute attr_foreground_new (uint color, uint start_index, uint end_index);
	[CCode (cheader_filename = "ibus.h")]
	public static void free_strv (string strv);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_address ();
	[CCode (cheader_filename = "ibus.h")]
	public static long get_daemon_uid ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_language_name (string _locale);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_local_machine_id ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_socket_path ();
	[CCode (cheader_filename = "ibus.h")]
	public static int get_timeout ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_user_name ();
	[CCode (cheader_filename = "ibus.h")]
	public static void init ();
	[CCode (cheader_filename = "ibus.h")]
	public static bool key_event_from_string (string string, uint keyval, uint modifiers);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string key_event_to_string (uint keyval, uint modifiers);
	[CCode (cheader_filename = "ibus.h")]
	public static uint keyval_from_name (string keyval_name);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string keyval_name (uint keyval);
	[CCode (cheader_filename = "ibus.h")]
	public static unichar keyval_to_unicode (uint keyval);
	[CCode (cheader_filename = "ibus.h")]
	public static void main ();
	[CCode (cheader_filename = "ibus.h")]
	public static void quit ();
	[CCode (cheader_filename = "ibus.h")]
	public static void set_display (string display);
	[CCode (cheader_filename = "ibus.h")]
	public static void set_log_handler (bool verbose);
	[CCode (cheader_filename = "ibus.h")]
	public static uint unicode_to_keyval (unichar wc);
	[CCode (cheader_filename = "ibus.h")]
	public static void unset_log_handler ();
	[CCode (cheader_filename = "ibus.h")]
	public static void write_address (string address);
}
