/*
 * $Id: chassis_at_aui_gen.c,v 1.5 2009-06-03 11:34:02 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue-aui-gen.h"

#include "chassis_at_aui.h"

struct cpssp {
	AuiGenChannel *channel;
};

static void
chassis_at_aui_audio_speaker_samples_set(void *_cpssp, int16_t *buf)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	aui_gen_channel_play(cpssp->channel, buf);
}

void *
chassis_at_aui_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_boolean *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	static const struct sig_sound_funcs audio_speaker_funcs = {
		.samples_set = chassis_at_aui_audio_speaker_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->channel = aui_gen_channel_new();

	/* In */
	sig_sound_connect(port_audio_speaker, cpssp, &audio_speaker_funcs);

	return cpssp;
}

void
chassis_at_aui_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
