/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggframereplicate.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "iviewsubject.h"
#include "ishell.h"

#include "iggwidgetarea.h"
#include "iggwidgetkeyselectionbox.h"


iggFrameReplicate::iggFrameReplicate(const iObjectType &type, iggFrame *parent) : iggFrame("Periodic extensions",parent,2), mDirKey(iObjectKeyRegistry::FindKey(iViewSubject::KeyDirectionIsPeriodic().RetypedKey(type),true))
{
	iggWidgetKeySpinBox *box1, *box2;

	const iObjectKey *key = iObjectKeyRegistry::FindKey(iViewSubject::KeyNumReplicas().RetypedKey(type)); IERROR_ASSERT(key);

	iggFrame *tmp = new iggFrame(this,2);
	tmp->AddLine(new iggWidgetTextArea("       Down",tmp),new iggWidgetTextArea("Up",tmp));
	this->AddLine(tmp);

	mDirs[0] = new iggFrame(this,3);
	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[0],0);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[0],1);
	mDirs[0]->AddLine(new iggWidgetTextArea("%b%+X",mDirs[0]),box1,box2);
	this->AddLine(mDirs[0]);

	mDirs[1] = new iggFrame(this,3);
	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[1],2);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[1],3);
	mDirs[1]->AddLine(new iggWidgetTextArea("%b%+Y",mDirs[1]),box1,box2);
	this->AddLine(mDirs[1]);

	mDirs[2] = new iggFrame(this,3);
	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[2],4);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,mDirs[2],5);
	mDirs[2]->AddLine(new iggWidgetTextArea("%b%+Z",mDirs[2]),box1,box2);
	this->AddLine(mDirs[2]);

	this->SetColStretch(1,10);
}


void iggFrameReplicate::UpdateChildren()
{
	this->iggFrame::UpdateChildren();

	if(mDirKey != 0)
	{
		int i;
		bool per[3];
		if(this->GetShell()->GetControlModule()->QueryValue(*mDirKey,per,3))
		{
			for(i=0; i<3; i++) mDirs[i]->Enable(per[i]);
		}
	}
}

#endif
