module Schleuder
  class ManageKeysPlugin < Plugin
    def initialize
      @plugin_type = :request
    end

    def list_keys(mail, value)
      Schleuder.log.debug 'LIST-KEY requested'
      listkeys(mail)
    end

    def add_key(mail, value)
      Schleuder.log.debug 'ADD-KEY requested'
      addkey(mail, mail.body)
    end

    def del_key(mail, value)
      Schleuder.log.debug 'DEL-KEY requested'
      # TODO: implement callback to sender with Hash to prevent replay
      # attacks.
      # Split at slash to work around some people's habit to include the
      # bitlength and key-type ("2048R/DEADBEEF"). If there's no slash this
      # won't do no harm. We need to force the string'iness to avoid nil's,
      # though.
      val = value.split('/').last.to_s
      msg = "The DEL-KEY-keyword is deprecated and will be removed some day in the future. Please use DELETE-KEY instead.".fmt
      msg << delkey(mail, val)
      msg
    end

    def delete_key(mail, value)
      Schleuder.log.debug 'DELETE-KEY requested'
      delkey(mail, value.split('/').last)
    end

    def send_key(mail, value)
      Schleuder.log.debug 'SEND-KEY requested'
      val = value.split('/').last
      msg = "The SEND-KEY-keyword is deprecated and will be removed some day in the future. Please use GET-KEY instead.".fmt
      msg << getkey(mail, val)
      msg
    end

    def get_key(mail, value)
      Schleuder.log.debug 'GET-KEY requested'
      val = value.split('/').last
      getkey(mail, val)
    end

    private

    def listkeys(mail)
      m = ""
      mail.crypt.list_keys.each do |k|
        if not (trust = [:revoked, :expired, :disabled, :invalid].grep(k.trust)).empty?
          m << "*Warning*: Key is #{trust.join(' and ')}!\n"
        end
        m << "#{k.to_s}"
        if (exp = k.subkeys.first.expires) > Time.utc(1971, 1, 1, 1)
          if exp < Time.now
            m << "Expired at #{exp}.\n"
          else
            m << "Expires at #{exp}.\n"
          end
        end
        m << "\n"
      end
      m
    end

    def addkey(mail, key)
      m = ""
      res = mail.crypt.add_key(key)
      res.imports.each do |i|
        if i.status == 1
          action = "imported"
        else
          action = "not imported"
        end
        m << "#{mail.crypt.get_key(i.fpr).to_s}\n--> #{action}\n\n"
      end
      m << "\nImportResult.inspect:\n=> #{res.inspect}"
      m
    end

    def delkey(mail, req)
      unless (key = mail.crypt.get_key(req)).first
        msg = "Failed to lookup key (#{req}) that should be deleted. Reason: #{key[1].capitalize}."
        Schleuder.log.debug msg
        return "--> #{msg}\n\n"
      end
      Schleuder.log.debug "Key to be deleted: #{key.inspect}"
      res = mail.crypt.delete_key(key.first)
      if res == true
        action = "Key deleted."
      else
        action = "Key not deleted.\nException: #{res.to_s}"
      end
      "#{key.to_s}\n--> #{action}\n\n"
    end

    def getkey(mail, req)
      keyblock = mail.crypt.export(req)
      if keyblock.empty?
        "#{req}\n\n--> No matching key present.\n"
      else
        "#{mail.crypt.list_keys(req).to_s.gsub(/^pub /, "\npub ")}\n\n#{keyblock}\n"
      end
    end

  end
end

