.TH "CONTEXT" "1" "June 2011" "context 0.52" "ConTeXt" 
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.de EX
.in +3
.nf
.ft CW
..
.de EE
.in -3
.ft R
.fi
..

.SH "NAME" 
context \- front end to the new ConTeXt typesetting system

.SH "SYNOPSIS" 
\fBcontext\fP [ \fIOPTION\fP ...  ] \fIFILE\fP [ ...  ]

.SH "DESCRIPTION" 
 
\fBcontext\fP, a \fBtexlua\fP(1) script,
is the command-line front end to the new version of the 
ConTeXt typesetting system, an extensive macro package
built on the \fBtex\fP(1) family of typesetting programs.
\fBcontext\fP provides several facilties:
.IP \(bu
Process a ConTeXt source file,
performing as many runs as
necessary of \fBluatex\fP(1).   Options control the output
format, the pages to process, paper size, and so forth.
.IP \(bu
Create new ConTeXt formats, useful during installation.
.IP \(bu
Post-process existing PDF files, including merging multiple
files, and extracting and rearranging pages within a file,
similar to the facilities provided for PostScript files by
\fBpsnup\fP(1) or for PDF files by \fBpdftk\fP(1).
.IP
.SH "OPTIONS" 
 
All switches should always be specified in full.  With no options, 
\fBcontext\fP assumes that
the file on the command line is a ConTeXt source file, i.e. a TeX file
in the ConTeXt dialect, and produces a PDF file using the source file.
 
.IP "\fB--run\fP"                  
process (one or more) files (default action)
.IP "\fB--make\fP"                 
create context formats
.IP "\fB--ctx\fP\fI=\fP\fIname\fP"             
use ctx file (process management specification)
.IP "\fB--interface\fP"
use specified user interface (default: en)
.IP "\fB--autopdf\fP"
close pdf file in viewer and start pdf viewer afterwards
.IP "\fB--purge(all)\fP"
purge files either or not after a run (\fB--pattern\fP\fI=\fP\fI...\fP)
.IP "\fB--usemodule\fP\fI=\fP\fIlist\fP"
load the given module or style, normally part o fthe distribution
.IP "\fB--environment\fP\fI=\fP\fIlist\fP"
load the given environment file first (document styles)
.IP "\fB--mode\fP\fI=\fP\fIlist\fP"
enable given the modes (conditional processing in styles)
.IP "\fB--path\fP\fI=\fP\fIlist\fP"
also consult the given paths when files are looked for
.IP "\fB--arguments\fP\fI=\fP\fIlist\fP"
set variables that can be consulted during a run (key/value pairs)
.IP "\fB--randomseed\fP\fI=\fP\fInumber\fP"
set the randomseed
.IP "\fB--result\fP\fI=\fP\fIname\fP"
rename the resulting output to the given name
.IP "\fB--trackers\fP\fI=\fP\fIlist\fP"
set tracker variables (show list with \fB--showtrackers\fP)
.IP "\fB--directives\fP\fI=\fP\fIlist\fP"
set directive variables (show list with \fB--showdirectives\fP)
.IP "\fB--silent\fP\fI=\fP\fIlist\fP"
disable logcatgories (show list with \fB--showlogcategories\fP)
.IP "\fB--noconsole\fP"
disable logging to the console (logfile only)
.IP "\fB--purgeresult\fP"
purge result file before run
.IP "\fB--forcexml\fP"
force xml stub (optional flag: \fB--mkii\fP)
.IP "\fB--forcecld\fP"
force cld (context lua document) stub
.IP "\fB--arrange\fP"
run extra imposition pass, given that the style sets up imposition
.IP "\fB--noarrange\fP"
ignore imposition specifications in the style
.IP "\fB--once\fP"
only run once (no multipass data file is produced)
.IP "\fB--batchmode\fP"
run without stopping and don't show messages on the console
.IP "\fB--nonstopmode\fP"
run without stopping
.IP "\fB--generate\fP"
generate file database etc. (as \fBmtxrun\fP does)
.IP "\fB--paranoid\fP"
don't descend to .. and ../..
.IP "\fB--version\fP"
report installed context version
.IP "\fB--expert\fP"
show expert options


.SH "INITIALIZATION" 

.PP
The \fBcontext\fP command is just a stub that runs the larger \fBmtxrun\fP
script, which is a scripting framework written for \fBtexlua\fP(1) that 
supports loading of extra modules, of which \fBcontext\fP is one. The 
implementation actually resides in a file named \fBmtx-context.lua\fP
deep within the TDS structure.

If \fBcontext\fP complains about \fBUnknown script 'context'\fP, this
can usually be fixed by executing \fBmtxrun --generate\fP on the
command line: this command regenerates the database that \fBmtxrun\fP
uses to find its extra modules.

.SH "SEE ALSO" 
.PP
\fBtex\fP(1), \fBluatex\fP(1), \fBtexlua\fP(1), \fBpsnup\fP(1), \fBpdftk\fP(1).
.PP
.URL "http://www.contextgarden.net" "ConTeXt wiki" .
.PP
.URL "http://www.ntg.nl/mailman/listinfo/ntg-context" "ConTeXt mailing list home" .

.SH "BUGS" 

.PP
This manpage is horribly incomplete.

.SH "AUTHOR" 
This partial manpage was written by Taco Hoekwater
<taco@metatex.org>.
It is based on the \fB--help\fP output of \fBcontext\fP.
