# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from .asyncclient import AsyncBaseClient
from .asyncclient import createApiClient
from .asyncclient import config
from .asyncclient import createTemporaryCredentials
from .asyncclient import createSession
_defaultConfig = config


class Notify(AsyncBaseClient):
    """
    The notification service, typically available at `notify.taskcluster.net`
    listens for tasks with associated notifications and handles requests to
    send emails and post pulse messages.
    """

    classOptions = {
    }
    serviceName = 'notify'
    apiVersion = 'v1'

    async def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    async def email(self, *args, **kwargs):
        """
        Send an Email

        Send an email to `address`. The content is markdown and will be rendered
        to HTML, but both the HTML and raw markdown text will be sent in the
        email. If a link is included, it will be rendered to a nice button in the
        HTML version of the email

        This method takes input: ``v1/email-request.json#``

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["email"], *args, **kwargs)

    async def pulse(self, *args, **kwargs):
        """
        Publish a Pulse Message

        Publish a message on pulse with the given `routingKey`.

        This method takes input: ``v1/pulse-request.json#``

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["pulse"], *args, **kwargs)

    async def irc(self, *args, **kwargs):
        """
        Post IRC Message

        Post a message on IRC to a specific channel or user, or a specific user
        on a specific channel.

        Success of this API method does not imply the message was successfully
        posted. This API method merely inserts the IRC message into a queue
        that will be processed by a background process.
        This allows us to re-send the message in face of connection issues.

        However, if the user isn't online the message will be dropped without
        error. We maybe improve this behavior in the future. For now just keep
        in mind that IRC is a best-effort service.

        This method takes input: ``v1/irc-request.json#``

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["irc"], *args, **kwargs)

    funcinfo = {
        "email": {
            'args': [],
            'input': 'v1/email-request.json#',
            'method': 'post',
            'name': 'email',
            'route': '/email',
            'stability': 'experimental',
        },
        "irc": {
            'args': [],
            'input': 'v1/irc-request.json#',
            'method': 'post',
            'name': 'irc',
            'route': '/irc',
            'stability': 'experimental',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
        "pulse": {
            'args': [],
            'input': 'v1/pulse-request.json#',
            'method': 'post',
            'name': 'pulse',
            'route': '/pulse',
            'stability': 'experimental',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'Notify']
